/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.support;

import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.test.util.AssertionErrors;

public abstract class AbstractStatusAssertions<E, R> {
    private final E exchangeResult;
    private final R responseSpec;

    protected AbstractStatusAssertions(E exchangeResult, R responseSpec) {
        this.exchangeResult = exchangeResult;
        this.responseSpec = responseSpec;
    }

    protected E getExchangeResult() {
        return this.exchangeResult;
    }

    protected abstract HttpStatusCode getStatus();

    protected abstract void assertWithDiagnostics(Runnable var1);

    public R isEqualTo(HttpStatusCode status) {
        HttpStatusCode actual = this.getStatus();
        this.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Status", status, actual));
        return this.responseSpec;
    }

    public R isEqualTo(int status) {
        return this.isEqualTo(HttpStatusCode.valueOf((int)status));
    }

    public R isOk() {
        return this.assertStatusAndReturn(HttpStatus.OK);
    }

    public R isCreated() {
        return this.assertStatusAndReturn(HttpStatus.CREATED);
    }

    public R isAccepted() {
        return this.assertStatusAndReturn(HttpStatus.ACCEPTED);
    }

    public R isNoContent() {
        return this.assertStatusAndReturn(HttpStatus.NO_CONTENT);
    }

    public R isFound() {
        return this.assertStatusAndReturn(HttpStatus.FOUND);
    }

    public R isSeeOther() {
        return this.assertStatusAndReturn(HttpStatus.SEE_OTHER);
    }

    public R isNotModified() {
        return this.assertStatusAndReturn(HttpStatus.NOT_MODIFIED);
    }

    public R isTemporaryRedirect() {
        return this.assertStatusAndReturn(HttpStatus.TEMPORARY_REDIRECT);
    }

    public R isPermanentRedirect() {
        return this.assertStatusAndReturn(HttpStatus.PERMANENT_REDIRECT);
    }

    public R isBadRequest() {
        return this.assertStatusAndReturn(HttpStatus.BAD_REQUEST);
    }

    public R isUnauthorized() {
        return this.assertStatusAndReturn(HttpStatus.UNAUTHORIZED);
    }

    public R isForbidden() {
        return this.assertStatusAndReturn(HttpStatus.FORBIDDEN);
    }

    public R isNotFound() {
        return this.assertStatusAndReturn(HttpStatus.NOT_FOUND);
    }

    public R reasonEquals(String reason) {
        String actual = AbstractStatusAssertions.getReasonPhrase(this.getStatus());
        this.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Response status reason", reason, actual));
        return this.responseSpec;
    }

    private static String getReasonPhrase(HttpStatusCode statusCode) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            return status.getReasonPhrase();
        }
        return "";
    }

    public R is1xxInformational() {
        return this.assertSeriesAndReturn(HttpStatus.Series.INFORMATIONAL);
    }

    public R is2xxSuccessful() {
        return this.assertSeriesAndReturn(HttpStatus.Series.SUCCESSFUL);
    }

    public R is3xxRedirection() {
        return this.assertSeriesAndReturn(HttpStatus.Series.REDIRECTION);
    }

    public R is4xxClientError() {
        return this.assertSeriesAndReturn(HttpStatus.Series.CLIENT_ERROR);
    }

    public R is5xxServerError() {
        return this.assertSeriesAndReturn(HttpStatus.Series.SERVER_ERROR);
    }

    public R value(Matcher<? super Integer> matcher) {
        int actual = this.getStatus().value();
        this.assertWithDiagnostics(() -> MatcherAssert.assertThat((String)"Response status", (Object)actual, (Matcher)matcher));
        return this.responseSpec;
    }

    public R value(Consumer<Integer> consumer) {
        int actual = this.getStatus().value();
        this.assertWithDiagnostics(() -> consumer.accept(actual));
        return this.responseSpec;
    }

    private R assertStatusAndReturn(HttpStatus expected) {
        AssertionErrors.assertNotNull("exchangeResult unexpectedly null", this.exchangeResult);
        HttpStatusCode actual = this.getStatus();
        this.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Status", expected, actual));
        return this.responseSpec;
    }

    private R assertSeriesAndReturn(HttpStatus.Series expected) {
        HttpStatusCode status = this.getStatus();
        HttpStatus.Series series = HttpStatus.Series.resolve((int)status.value());
        this.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Range for response status value " + String.valueOf(status), expected, series));
        return this.responseSpec;
    }
}

