/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client;

import jakarta.servlet.http.Cookie;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class MockMvcClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final MockMvc mockMvc;

    MockMvcClientHttpRequestFactory(MockMvc mockMvc) {
        Assert.notNull((Object)mockMvc, (String)"MockMvc must not be null");
        this.mockMvc = mockMvc;
    }

    public ClientHttpRequest createRequest(final URI uri, final HttpMethod httpMethod) {
        return new MockClientHttpRequest(this, httpMethod, uri){
            final /* synthetic */ MockMvcClientHttpRequestFactory this$0;
            {
                this.this$0 = this$0;
                super(httpMethod3, uri2);
            }

            @Override
            public ClientHttpResponse executeInternal() {
                return this.this$0.getClientHttpResponse(httpMethod, uri, this.getHeaders(), this.getBodyAsBytes());
            }
        };
    }

    private ClientHttpResponse getClientHttpResponse(HttpMethod httpMethod, URI uri, HttpHeaders requestHeaders, byte[] requestBody) {
        try {
            String error;
            Cookie[] cookies = MockMvcClientHttpRequestFactory.parseCookies(requestHeaders.get("Cookie"));
            MockHttpServletRequestBuilder requestBuilder = MockMvcRequestBuilders.request(httpMethod, uri).content(requestBody).headers(requestHeaders);
            if (cookies.length > 0) {
                requestBuilder.cookie(cookies);
            }
            MockHttpServletResponse servletResponse = this.mockMvc.perform(requestBuilder).andReturn().getResponse();
            HttpStatusCode status = HttpStatusCode.valueOf((int)servletResponse.getStatus());
            byte[] body2 = servletResponse.getContentAsByteArray();
            if (body2.length == 0 && StringUtils.hasLength((String)(error = servletResponse.getErrorMessage()))) {
                body2 = error.getBytes(StandardCharsets.UTF_8);
            }
            MockClientHttpResponse clientResponse = new MockClientHttpResponse(body2, status);
            clientResponse.getHeaders().putAll(this.getResponseHeaders(servletResponse));
            return clientResponse;
        }
        catch (Exception ex) {
            byte[] body3 = ex.toString().getBytes(StandardCharsets.UTF_8);
            return new MockClientHttpResponse(body3, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private static Cookie[] parseCookies(@Nullable List<String> headerValues) {
        if (headerValues == null) {
            return new Cookie[0];
        }
        return (Cookie[])headerValues.stream().flatMap(header -> StringUtils.commaDelimitedListToSet((String)header).stream()).map(MockMvcClientHttpRequestFactory::parseCookie).toArray(Cookie[]::new);
    }

    private static Cookie parseCookie(String cookie) {
        String[] parts = StringUtils.split((String)cookie, (String)"=");
        Assert.isTrue((parts != null && parts.length == 2 ? 1 : 0) != 0, (String)("Invalid cookie: '" + cookie + "'"));
        return new Cookie(parts[0], parts[1]);
    }

    private HttpHeaders getResponseHeaders(MockHttpServletResponse response) {
        HttpHeaders headers = new HttpHeaders();
        for (String name : response.getHeaderNames()) {
            Collection values = response.getHeaders(name);
            for (String value : values) {
                headers.add(name, value);
            }
        }
        return headers;
    }
}

