/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ActiveProfilesResolver;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;

public class DefaultActiveProfilesResolver
implements ActiveProfilesResolver {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Log logger = LogFactory.getLog(DefaultActiveProfilesResolver.class);

    @Override
    public String[] resolve(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        MetaAnnotationUtils.AnnotationDescriptor<ActiveProfiles> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, ActiveProfiles.class);
        if (descriptor == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", ActiveProfiles.class.getName(), testClass.getName()));
            }
            return EMPTY_STRING_ARRAY;
        }
        ActiveProfiles annotation = descriptor.synthesizeAnnotation();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("Retrieved @ActiveProfiles [%s] for declaring class [%s].", annotation, descriptor.getDeclaringClass().getName()));
        }
        return annotation.profiles();
    }
}

