/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.rmi.server.RMIClassLoader;
import org.springframework.util.ClassUtils;

public class CodebaseAwareObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;
    private final String codebaseUrl;

    public CodebaseAwareObjectInputStream(InputStream in, String codebaseUrl) throws IOException {
        this(in, null, codebaseUrl);
    }

    public CodebaseAwareObjectInputStream(InputStream in, ClassLoader classLoader, String codebaseUrl) throws IOException {
        super(in);
        this.classLoader = classLoader;
        this.codebaseUrl = codebaseUrl;
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        try {
            if (this.classLoader != null) {
                return Class.forName(classDesc.getName(), false, this.classLoader);
            }
            return super.resolveClass(classDesc);
        }
        catch (ClassNotFoundException ex) {
            Class clazz = ClassUtils.resolvePrimitiveClassName((String)classDesc.getName());
            if (clazz != null) {
                return clazz;
            }
            if (this.codebaseUrl == null) {
                throw ex;
            }
            return RMIClassLoader.loadClass(this.codebaseUrl, classDesc.getName());
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        if (this.classLoader != null) {
            Class[] resolvedInterfaces = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                try {
                    resolvedInterfaces[i] = Class.forName(interfaces[i], false, this.classLoader);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    if (this.codebaseUrl == null) {
                        throw ex;
                    }
                    resolvedInterfaces[i] = RMIClassLoader.loadClass(this.codebaseUrl, interfaces[i]);
                }
            }
            try {
                return Proxy.getProxyClass(this.classLoader, resolvedInterfaces);
            }
            catch (IllegalArgumentException ex) {
                throw new ClassNotFoundException(null, ex);
            }
        }
        try {
            return super.resolveProxyClass(interfaces);
        }
        catch (ClassNotFoundException ex) {
            if (this.codebaseUrl == null) {
                throw ex;
            }
            ClassLoader loader = RMIClassLoader.getClassLoader(this.codebaseUrl);
            Class[] resolvedInterfaces = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                resolvedInterfaces[i] = loader.loadClass(interfaces[i]);
            }
            return Proxy.getProxyClass(loader, resolvedInterfaces);
        }
    }
}

