/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.AbstractMessageReceivingTemplate;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.core.MessageRequestReplyOperations;

public abstract class AbstractMessagingTemplate<D>
extends AbstractMessageReceivingTemplate<D>
implements MessageRequestReplyOperations<D> {
    @Override
    public @Nullable Message<?> sendAndReceive(Message<?> requestMessage) throws MessagingException {
        return this.sendAndReceive(this.getRequiredDefaultDestination(), requestMessage);
    }

    @Override
    public @Nullable Message<?> sendAndReceive(D destination, Message<?> requestMessage) throws MessagingException {
        return this.doSendAndReceive(destination, requestMessage);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(Object request, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(request, null, targetClass, null);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(D destination, Object request, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(destination, request, null, targetClass, null);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(Object request, @Nullable Map<String, Object> headers, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(request, headers, targetClass, null);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(D destination, Object request, @Nullable Map<String, Object> headers, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(destination, request, headers, targetClass, null);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(Object request, Class<T> targetClass, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        return this.convertSendAndReceive(request, null, targetClass, postProcessor);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(D destination, Object request, Class<T> targetClass, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        return this.convertSendAndReceive(destination, request, null, targetClass, postProcessor);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(Object request, @Nullable Map<String, Object> headers, Class<T> targetClass, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        return this.convertSendAndReceive(this.getRequiredDefaultDestination(), request, headers, targetClass, postProcessor);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(D destination, Object request, @Nullable Map<String, Object> headers, Class<T> targetClass, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        Message<?> requestMessage = this.doConvert(request, headers, postProcessor);
        Message<?> replyMessage = this.doSendAndReceive(destination, requestMessage);
        return (T)(replyMessage != null ? this.getMessageConverter().fromMessage(replyMessage, targetClass) : null);
    }

    protected abstract @Nullable Message<?> doSendAndReceive(D var1, Message<?> var2);
}

