/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public final class RSocketRequestValues {
    @Nullable
    private final String route;
    private final Object[] routeVariables;
    private final Map<Object, MimeType> metadata;
    @Nullable
    private final Object payloadValue;
    @Nullable
    private final Publisher<?> payload;
    @Nullable
    private final ParameterizedTypeReference<?> payloadElementType;

    public RSocketRequestValues(@Nullable String route, @Nullable List<Object> routeVariables, @Nullable MetadataHelper metadataHelper, @Nullable Object payloadValue, @Nullable Publisher<?> payload, @Nullable ParameterizedTypeReference<?> payloadElementType) {
        this.route = route;
        this.routeVariables = routeVariables != null ? routeVariables.toArray() : new Object[]{};
        this.metadata = metadataHelper != null ? metadataHelper.toMap() : Collections.emptyMap();
        this.payloadValue = payloadValue;
        this.payload = payload;
        this.payloadElementType = payloadElementType;
    }

    @Nullable
    public String getRoute() {
        return this.route;
    }

    public Object[] getRouteVariables() {
        return this.routeVariables;
    }

    public Map<Object, MimeType> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public Object getPayloadValue() {
        return this.payloadValue;
    }

    @Nullable
    public Publisher<?> getPayload() {
        return this.payload;
    }

    @Nullable
    public ParameterizedTypeReference<?> getPayloadElementType() {
        return this.payloadElementType;
    }

    public static Builder builder(@Nullable String route) {
        return new Builder(route);
    }

    private static class MetadataHelper {
        private final List<Object> metadata = new ArrayList<Object>();
        private final List<MimeType> mimeTypes = new ArrayList<MimeType>();

        private MetadataHelper() {
        }

        public void addMetadata(Object metadata) {
            Assert.isTrue((this.metadata.size() == this.mimeTypes.size() ? 1 : 0) != 0, () -> "Invalid state: " + this);
            this.metadata.add(metadata);
        }

        public void addMimeType(MimeType mimeType) {
            Assert.isTrue((this.metadata.size() == this.mimeTypes.size() + 1 ? 1 : 0) != 0, () -> "Invalid state: " + this);
            this.mimeTypes.add(mimeType);
        }

        public Map<Object, MimeType> toMap() {
            LinkedHashMap<Object, MimeType> map = new LinkedHashMap<Object, MimeType>(this.metadata.size());
            for (int i2 = 0; i2 < this.metadata.size(); ++i2) {
                map.put(this.metadata.get(i2), this.mimeTypes.get(i2));
            }
            return map;
        }

        public String toString() {
            return "metadata=" + this.metadata + ", mimeTypes=" + this.mimeTypes;
        }
    }

    public static final class Builder {
        @Nullable
        private String route;
        @Nullable
        private List<Object> routeVariables;
        @Nullable
        private MetadataHelper metadataHelper;
        @Nullable
        private Object payloadValue;
        @Nullable
        private Publisher<?> payload;
        @Nullable
        private ParameterizedTypeReference<?> payloadElementType;

        Builder(@Nullable String route) {
            this.route = StringUtils.hasText((String)route) ? route : null;
        }

        public Builder setRoute(String route) {
            this.route = route;
            this.routeVariables = null;
            return this;
        }

        public Builder addRouteVariable(Object variable) {
            this.routeVariables = this.routeVariables != null ? this.routeVariables : new ArrayList<Object>();
            this.routeVariables.add(variable);
            return this;
        }

        public Builder addMetadata(Object metadata) {
            this.metadataHelper = this.metadataHelper != null ? this.metadataHelper : new MetadataHelper();
            this.metadataHelper.addMetadata(metadata);
            return this;
        }

        public Builder addMimeType(MimeType mimeType) {
            this.metadataHelper = this.metadataHelper != null ? this.metadataHelper : new MetadataHelper();
            this.metadataHelper.addMimeType(mimeType);
            return this;
        }

        public Builder setPayloadValue(Object payloadValue) {
            this.payloadValue = payloadValue;
            this.payload = null;
            this.payloadElementType = null;
            return this;
        }

        public <T, P extends Publisher<T>> Builder setPayload(P payload, ParameterizedTypeReference<T> elementTye) {
            this.payload = payload;
            this.payloadElementType = elementTye;
            this.payloadValue = null;
            return this;
        }

        public RSocketRequestValues build() {
            return new RSocketRequestValues(this.route, this.routeVariables, this.metadataHelper, this.payloadValue, this.payload, this.payloadElementType);
        }
    }
}

