/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.FileSystemGeneratedFiles;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.nativex.FileNativeConfigurationWriter;
import org.springframework.util.Assert;
import org.springframework.util.FileSystemUtils;

public abstract class AbstractAotProcessor<T> {
    public static final String AOT_PROCESSING = "spring.aot.processing";
    private final Settings settings;

    protected AbstractAotProcessor(Settings settings) {
        this.settings = settings;
    }

    protected Settings getSettings() {
        return this.settings;
    }

    public final T process() {
        try {
            System.setProperty(AOT_PROCESSING, "true");
            T t = this.doProcess();
            return t;
        }
        finally {
            System.clearProperty(AOT_PROCESSING);
        }
    }

    protected abstract T doProcess();

    protected void deleteExistingOutput() {
        this.deleteExistingOutput(this.getSettings().getSourceOutput(), this.getSettings().getResourceOutput(), this.getSettings().getClassOutput());
    }

    private void deleteExistingOutput(Path ... paths) {
        for (Path path : paths) {
            try {
                FileSystemUtils.deleteRecursively((Path)path);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to delete existing output in '" + String.valueOf(path) + "'", ex);
            }
        }
    }

    protected FileSystemGeneratedFiles createFileSystemGeneratedFiles() {
        return new FileSystemGeneratedFiles(this::getRoot);
    }

    private Path getRoot(GeneratedFiles.Kind kind) {
        return switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case GeneratedFiles.Kind.SOURCE -> this.getSettings().getSourceOutput();
            case GeneratedFiles.Kind.RESOURCE -> this.getSettings().getResourceOutput();
            case GeneratedFiles.Kind.CLASS -> this.getSettings().getClassOutput();
        };
    }

    protected void writeHints(RuntimeHints hints) {
        FileNativeConfigurationWriter writer = new FileNativeConfigurationWriter(this.getSettings().getResourceOutput(), this.getSettings().getGroupId(), this.getSettings().getArtifactId());
        writer.write(hints);
    }

    public static final class Settings {
        private final Path sourceOutput;
        private final Path resourceOutput;
        private final Path classOutput;
        private final String groupId;
        private final String artifactId;

        private Settings(Path sourceOutput, Path resourceOutput, Path classOutput, String groupId, String artifactId) {
            this.sourceOutput = sourceOutput;
            this.resourceOutput = resourceOutput;
            this.classOutput = classOutput;
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Path getSourceOutput() {
            return this.sourceOutput;
        }

        public Path getResourceOutput() {
            return this.resourceOutput;
        }

        public Path getClassOutput() {
            return this.classOutput;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public static final class Builder {
            private @Nullable Path sourceOutput;
            private @Nullable Path resourceOutput;
            private @Nullable Path classOutput;
            private @Nullable String groupId;
            private @Nullable String artifactId;

            private Builder() {
            }

            public Builder sourceOutput(Path sourceOutput) {
                this.sourceOutput = sourceOutput;
                return this;
            }

            public Builder resourceOutput(Path resourceOutput) {
                this.resourceOutput = resourceOutput;
                return this;
            }

            public Builder classOutput(Path classOutput) {
                this.classOutput = classOutput;
                return this;
            }

            public Builder groupId(String groupId) {
                Assert.hasText((String)groupId, (String)"'groupId' must not be empty");
                this.groupId = groupId;
                return this;
            }

            public Builder artifactId(String artifactId) {
                Assert.hasText((String)artifactId, (String)"'artifactId' must not be empty");
                this.artifactId = artifactId;
                return this;
            }

            public Settings build() {
                Assert.notNull((Object)this.sourceOutput, (String)"'sourceOutput' must not be null");
                Assert.notNull((Object)this.resourceOutput, (String)"'resourceOutput' must not be null");
                Assert.notNull((Object)this.classOutput, (String)"'classOutput' must not be null");
                Assert.notNull((Object)this.groupId, (String)"'groupId' must not be null");
                Assert.notNull((Object)this.artifactId, (String)"'artifactId' must not be null");
                return new Settings(this.sourceOutput, this.resourceOutput, this.classOutput, this.groupId, this.artifactId);
            }
        }
    }
}

