/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.CollectionUtils;
import org.springframework.util.function.SingletonSupplier;

@Configuration(proxyBeanMethods=false)
public abstract class AbstractCachingConfiguration
implements ImportAware {
    protected @Nullable AnnotationAttributes enableCaching;
    protected @Nullable Supplier<? extends @Nullable CacheManager> cacheManager;
    protected @Nullable Supplier<? extends @Nullable CacheResolver> cacheResolver;
    protected @Nullable Supplier<? extends @Nullable KeyGenerator> keyGenerator;
    protected @Nullable Supplier<? extends @Nullable CacheErrorHandler> errorHandler;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableCaching = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableCaching.class.getName()));
        if (this.enableCaching == null) {
            throw new IllegalArgumentException("@EnableCaching is not present on importing class " + importMetadata.getClassName());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Autowired
    void setConfigurers(ObjectProvider<CachingConfigurer> configurers) {
        Supplier<@Nullable CachingConfigurer> configurer = () -> {
            List candidates = configurers.stream().toList();
            if (CollectionUtils.isEmpty(candidates)) {
                return null;
            }
            if (candidates.size() > 1) {
                throw new IllegalStateException(candidates.size() + " implementations of CachingConfigurer were found when only 1 was expected. Refactor the configuration such that CachingConfigurer is implemented only once or not at all.");
            }
            return (CachingConfigurer)candidates.get(0);
        };
        this.useCachingConfigurer(new CachingConfigurerSupplier(configurer));
    }

    protected void useCachingConfigurer(CachingConfigurerSupplier cachingConfigurerSupplier) {
        this.cacheManager = cachingConfigurerSupplier.adapt(CachingConfigurer::cacheManager);
        this.cacheResolver = cachingConfigurerSupplier.adapt(CachingConfigurer::cacheResolver);
        this.keyGenerator = cachingConfigurerSupplier.adapt(CachingConfigurer::keyGenerator);
        this.errorHandler = cachingConfigurerSupplier.adapt(CachingConfigurer::errorHandler);
    }

    protected static class CachingConfigurerSupplier {
        private final SingletonSupplier<CachingConfigurer> supplier;

        public CachingConfigurerSupplier(Supplier<? extends @Nullable CachingConfigurer> supplier) {
            this.supplier = SingletonSupplier.ofNullable(supplier);
        }

        public <T> Supplier<@Nullable T> adapt(Function<CachingConfigurer, ? extends @Nullable T> provider) {
            return () -> {
                CachingConfigurer cachingConfigurer = (CachingConfigurer)this.supplier.get();
                return cachingConfigurer != null ? provider.apply(cachingConfigurer) : null;
            };
        }
    }
}

