/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail.javamail;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.springframework.core.io.InputStreamSource;

public class MimeMessageHelper {
    private final MimeMessage mimeMessage;
    private MimeMultipart mimeMultipart = null;

    public MimeMessageHelper(MimeMessage mimeMessage) {
        this.mimeMessage = mimeMessage;
    }

    public MimeMessageHelper(MimeMessage mimeMessage, boolean multipart) throws MessagingException {
        this.mimeMessage = mimeMessage;
        if (multipart) {
            this.mimeMultipart = new MimeMultipart();
            this.mimeMessage.setContent((Multipart)this.mimeMultipart);
        }
    }

    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public void setFrom(String from) throws MessagingException {
        this.mimeMessage.setFrom((Address)new InternetAddress(from));
    }

    public void setTo(String to) throws MessagingException {
        this.mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
    }

    public void setTo(String[] to) throws MessagingException {
        for (int i = 0; i < to.length; ++i) {
            this.mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to[i]));
        }
    }

    public void setCc(String cc) throws MessagingException {
        this.mimeMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
    }

    public void setCc(String[] cc) throws MessagingException {
        for (int i = 0; i < cc.length; ++i) {
            this.mimeMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc[i]));
        }
    }

    public void setBcc(String bcc) throws MessagingException {
        this.mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
    }

    public void setBcc(String[] bcc) throws MessagingException {
        for (int i = 0; i < bcc.length; ++i) {
            this.mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc[i]));
        }
    }

    public void setSubject(String subject) throws MessagingException {
        this.mimeMessage.setSubject(subject);
    }

    public void setText(String text) throws MessagingException {
        this.setText(text, false);
    }

    public void setText(final String text, boolean html) throws MessagingException {
        MimeMessage partToUse = null;
        if (this.mimeMultipart != null) {
            BodyPart bodyPart = null;
            for (int i = 0; i < this.mimeMultipart.getCount(); ++i) {
                BodyPart bp = this.mimeMultipart.getBodyPart(i);
                if (bp.getFileName() != null) continue;
                bodyPart = bp;
            }
            if (bodyPart == null) {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                this.mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                bodyPart = mimeBodyPart;
            }
            partToUse = bodyPart;
        } else {
            partToUse = this.mimeMessage;
        }
        if (html) {
            partToUse.setDataHandler(new DataHandler(new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(text.getBytes());
                }

                public OutputStream getOutputStream() throws IOException {
                    throw new UnsupportedOperationException("Read-only javax.activation.DataSource");
                }

                public String getContentType() {
                    return "text/html";
                }

                public String getName() {
                    return "text";
                }
            }));
        } else {
            partToUse.setText(text);
        }
    }

    public void addAttachment(String attachmentFilename, File file) throws MessagingException {
        this.addAttachment(attachmentFilename, (DataSource)new FileDataSource(file));
    }

    public void addAttachment(final String attachmentFilename, final InputStreamSource inputStreamSource) throws MessagingException {
        this.addAttachment(attachmentFilename, new DataSource(){

            public InputStream getInputStream() throws IOException {
                return inputStreamSource.getInputStream();
            }

            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException("Read-only javax.activation.DataSource");
            }

            public String getContentType() {
                return FileTypeMap.getDefaultFileTypeMap().getContentType(attachmentFilename);
            }

            public String getName() {
                return attachmentFilename;
            }
        });
    }

    public void addAttachment(String attachmentFilename, DataSource dataSource) throws MessagingException {
        if (this.mimeMultipart == null) {
            throw new IllegalStateException("Cannot add attachment - not in multipart mode");
        }
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setFileName(attachmentFilename);
        bodyPart.setDataHandler(new DataHandler(dataSource));
        this.mimeMultipart.addBodyPart((BodyPart)bodyPart);
    }
}

