/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.Serializable;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.StringUtils;

public class MessageSourceResolvableImpl
implements MessageSourceResolvable,
Serializable {
    private final String[] codes;
    private final Object[] args;
    private final String defaultMessage;

    public MessageSourceResolvableImpl(String[] codes, Object[] args, String defaultMessage) {
        this.codes = codes;
        this.args = args;
        this.defaultMessage = defaultMessage;
    }

    public MessageSourceResolvableImpl(String[] codes, Object[] args) {
        this(codes, args, null);
    }

    public MessageSourceResolvableImpl(MessageSourceResolvable resolvable) {
        this(resolvable.getCodes(), resolvable.getArgs(), resolvable.getDefaultMessage());
    }

    public String[] getCodes() {
        return this.codes;
    }

    public String getCode() {
        return this.codes != null && this.codes.length > 0 ? this.codes[this.codes.length - 1] : null;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    protected String resolvableToString() {
        StringBuffer msgBuff = new StringBuffer();
        msgBuff.append("codes=[" + StringUtils.arrayToDelimitedString(this.getCodes(), ",") + "]; args=[");
        if (this.args == null) {
            msgBuff.append("null");
        } else {
            for (int i = 0; i < this.getArgs().length; ++i) {
                msgBuff.append("(" + this.getArgs()[i].getClass().getName() + ")[" + this.getArgs()[i] + "]");
                if (i >= this.getArgs().length - 1) continue;
                msgBuff.append(", ");
            }
        }
        msgBuff.append("]; defaultMessage=[" + this.getDefaultMessage() + "]");
        return msgBuff.toString();
    }

    public String toString() {
        return this.resolvableToString();
    }
}

