/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.beans.factory.support.RuntimeBeanReference;

public class PropertyPlaceholderConfigurer
extends PropertyResourceConfigurer {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            PropertyValues pvs = beanFactory.getPropertyValues(beanName);
            if (pvs == null) continue;
            for (int j = 0; j < pvs.getPropertyValues().length; ++j) {
                PropertyValue pv = pvs.getPropertyValues()[j];
                if (pv.getValue() instanceof String) {
                    String strVal = (String)pv.getValue();
                    String newStrVal = this.parseValue(props, strVal);
                    if (newStrVal.equals(strVal)) continue;
                    beanFactory.overridePropertyValue(beanName, new PropertyValue(pv.getName(), newStrVal));
                    this.logger.debug((Object)("Property '" + beanName + "." + pv.getName() + "' set to [" + newStrVal + "]"));
                    continue;
                }
                if (pv.getValue() instanceof RuntimeBeanReference) {
                    RuntimeBeanReference ref = (RuntimeBeanReference)pv.getValue();
                    String newBeanName = this.parseValue(props, ref.getBeanName());
                    if (newBeanName.equals(ref.getBeanName())) continue;
                    RuntimeBeanReference newRef = new RuntimeBeanReference(newBeanName);
                    beanFactory.overridePropertyValue(beanName, new PropertyValue(pv.getName(), newRef));
                    this.logger.debug((Object)("Property '" + beanName + "." + pv.getName() + "' set to bean reference '" + beanName + "'"));
                    continue;
                }
                if (pv.getValue() instanceof List) {
                    List listVal = (List)pv.getValue();
                    for (int k = 0; k < listVal.size(); ++k) {
                        RuntimeBeanReference ref;
                        String newBeanName;
                        Object elem = listVal.get(k);
                        if (elem instanceof String) {
                            String strVal = (String)elem;
                            String newStrVal = this.parseValue(props, strVal);
                            if (newStrVal.equals(strVal)) continue;
                            listVal.set(k, newStrVal);
                            this.logger.debug((Object)("Property '" + beanName + "." + pv.getName() + "' set to [" + newStrVal + "]"));
                            continue;
                        }
                        if (!(elem instanceof RuntimeBeanReference) || (newBeanName = this.parseValue(props, (ref = (RuntimeBeanReference)elem).getBeanName())).equals(ref.getBeanName())) continue;
                        RuntimeBeanReference newRef = new RuntimeBeanReference(newBeanName);
                        listVal.set(k, newRef);
                        this.logger.debug((Object)("List element '" + k + "' of property '" + beanName + "." + pv.getName() + "' set to bean reference '" + beanName + "'"));
                    }
                    continue;
                }
                if (!(pv.getValue() instanceof Map)) continue;
                Map mapVal = (Map)pv.getValue();
                Iterator it = new HashMap(mapVal).keySet().iterator();
                while (it.hasNext()) {
                    RuntimeBeanReference ref;
                    String newBeanName;
                    Object key = it.next();
                    Object elem = mapVal.get(key);
                    if (elem instanceof String) {
                        String strVal = (String)elem;
                        String newStrVal = this.parseValue(props, strVal);
                        if (newStrVal.equals(strVal)) continue;
                        mapVal.put(key, newStrVal);
                        this.logger.debug((Object)("Property '" + beanName + "." + pv.getName() + "' set to [" + newStrVal + "]"));
                        continue;
                    }
                    if (!(elem instanceof RuntimeBeanReference) || (newBeanName = this.parseValue(props, (ref = (RuntimeBeanReference)elem).getBeanName())).equals(ref.getBeanName())) continue;
                    RuntimeBeanReference newRef = new RuntimeBeanReference(newBeanName);
                    mapVal.put(key, newRef);
                    this.logger.debug((Object)("Map element '" + key + "' of property '" + beanName + "." + pv.getName() + "' set to bean reference '" + beanName + "'"));
                }
            }
        }
    }

    protected String parseValue(Properties prop, String strVal) throws BeansException {
        return this.parseValue(prop, strVal, null);
    }

    protected String parseValue(Properties prop, String strVal, String originalPlaceholder) throws BeansException {
        int startIndex = strVal.indexOf(this.placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = strVal.indexOf(this.placeholderSuffix, startIndex + this.placeholderPrefix.length());
            if (startIndex != -1 && endIndex != -1) {
                String placeholder = strVal.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                if (originalPlaceholder == null) {
                    originalPlaceholder = placeholder;
                } else if (placeholder.equals(originalPlaceholder)) {
                    throw new BeanDefinitionStoreException("Circular placeholder reference '" + placeholder + "' in property definitions [" + prop + "]");
                }
                String propVal = prop.getProperty(placeholder);
                if (propVal != null) {
                    propVal = this.parseValue(prop, propVal, originalPlaceholder);
                    this.logger.debug((Object)("Resolving placeholder '" + placeholder + "' to [" + propVal + "]"));
                    strVal = strVal.substring(0, startIndex) + propVal + strVal.substring(endIndex + 1);
                    startIndex = strVal.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                    continue;
                }
                this.logger.debug((Object)("Could not resolve placeholder '" + placeholder + "'"));
                startIndex = strVal.indexOf(this.placeholderPrefix, endIndex);
                continue;
            }
            startIndex = -1;
        }
        return strVal;
    }
}

