/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyVetoException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.ErrorCodedPropertyVetoException;
import org.springframework.beans.InvalidPropertyValuesException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.StringUtils;

public class PropertyVetoExceptionsException
extends BeansException {
    private List exceptions = new LinkedList();
    private BeanWrapper beanWrapper;

    PropertyVetoExceptionsException(BeanWrapper beanWrapper) {
        super("PropertyVetoExceptionsException", null);
        this.beanWrapper = beanWrapper;
    }

    public BeanWrapper getBeanWrapper() {
        return this.beanWrapper;
    }

    public Object getBindObject() {
        return this.beanWrapper.getWrappedInstance();
    }

    public Map getMessages() {
        HashMap<String, String> msgs = new HashMap<String, String>();
        Iterator it = this.exceptions.iterator();
        while (it.hasNext()) {
            ErrorCodedPropertyVetoException ex = (ErrorCodedPropertyVetoException)it.next();
            msgs.put(ex.getPropertyChangeEvent().getPropertyName(), ex.getErrorCode() + ": " + ex.getMessage());
        }
        return msgs;
    }

    public Iterator iterator() {
        return new Iterator(){
            int count;

            public boolean hasNext() {
                return this.count < PropertyVetoExceptionsException.this.getExceptionCount();
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("PropertyVetoExceptionExceptions iterator has only " + PropertyVetoExceptionsException.this.getExceptionCount() + " elements");
                }
                return PropertyVetoExceptionsException.this.exceptions.get(this.count++);
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot remove elements from PropertyVetoExceptionExceptions iterator");
            }
        };
    }

    public int getExceptionCount() {
        return this.exceptions.size();
    }

    public ErrorCodedPropertyVetoException[] getPropertyVetoExceptions() {
        return this.exceptions.toArray(new ErrorCodedPropertyVetoException[0]);
    }

    public ErrorCodedPropertyVetoException getPropertyVetoException(String propertyName) {
        Iterator itr = this.exceptions.iterator();
        while (itr.hasNext()) {
            ErrorCodedPropertyVetoException pve = (ErrorCodedPropertyVetoException)itr.next();
            if (!propertyName.equals(pve.getPropertyChangeEvent().getPropertyName())) continue;
            return pve;
        }
        return null;
    }

    void addPropertyVetoException(PropertyVetoException ex) {
        if (ex instanceof ErrorCodedPropertyVetoException) {
            this.addErrorCodedPropertyVetoException((ErrorCodedPropertyVetoException)ex);
        } else {
            this.exceptions.add(new ErrorCodedPropertyVetoException(ex));
        }
    }

    void addErrorCodedPropertyVetoException(ErrorCodedPropertyVetoException ex) {
        this.exceptions.add(ex);
    }

    void addTypeMismatchException(TypeMismatchException ex) {
        this.addPropertyVetoException(new ErrorCodedPropertyVetoException(ex));
    }

    void addMissingFields(InvalidPropertyValuesException ex) {
        for (int i = 0; i < ex.getMissingFields().size(); ++i) {
            this.addPropertyVetoException(new ErrorCodedPropertyVetoException(this.getBindObject(), (InvalidPropertyValuesException.MissingFieldException)ex.getMissingFields().get(i)));
        }
    }

    void addMethodInvocationException(MethodInvocationException ex) {
        this.addPropertyVetoException(new ErrorCodedPropertyVetoException(ex));
    }

    public void printStackTrace(PrintStream ps) {
        Iterator it = this.exceptions.iterator();
        while (it.hasNext()) {
            ps.println(this);
            ErrorCodedPropertyVetoException ex = (ErrorCodedPropertyVetoException)it.next();
            ex.getRootCause().printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        Iterator it = this.exceptions.iterator();
        while (it.hasNext()) {
            pw.println(this);
            ErrorCodedPropertyVetoException ex = (ErrorCodedPropertyVetoException)it.next();
            ex.getRootCause().printStackTrace(pw);
        }
    }

    public String toString() {
        String s = "PropertyVetoExceptionsException: " + this.getExceptionCount() + " errors:-- ";
        s = s + StringUtils.collectionToDelimitedString(this.exceptions, ";");
        return s;
    }
}

