/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import org.springframework.beans.ErrorCodedPropertyVetoException;
import org.springframework.beans.InvalidPropertyValuesException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.ParameterizableErrorCoded;

public class ParameterizableErrorCodedPropertyVetoException
extends ErrorCodedPropertyVetoException
implements ParameterizableErrorCoded {
    private Object[] errorArgs = null;

    public ParameterizableErrorCodedPropertyVetoException(String mesg, PropertyChangeEvent e, String errorCode, Object[] errorArgs) {
        super(mesg, e, errorCode);
        this.errorArgs = errorArgs;
    }

    ParameterizableErrorCodedPropertyVetoException(PropertyVetoException ex) {
        super(ex);
        this.errorArgs = ex instanceof ParameterizableErrorCoded ? ((ParameterizableErrorCoded)((Object)ex)).getErrorArgs() : null;
    }

    ParameterizableErrorCodedPropertyVetoException(TypeMismatchException ex) {
        super(ex);
        this.errorArgs = null;
    }

    ParameterizableErrorCodedPropertyVetoException(MethodInvocationException ex) {
        super(ex);
        this.errorArgs = null;
    }

    ParameterizableErrorCodedPropertyVetoException(Object source, InvalidPropertyValuesException.MissingFieldException ex) {
        super(source, ex);
        this.errorArgs = null;
    }

    public Object[] getErrorArgs() {
        return this.errorArgs;
    }

    public String toString() {
        StringBuffer msgBuff = null;
        msgBuff.append("ErrorCodedPropertyVetoException: message=[" + this.getMessage() + "]; " + "errorCode=[" + this.getErrorCode() + "]");
        if (this.errorArgs != null) {
            msgBuff.append("; errorArgs=[");
            for (int i = 0; i < this.errorArgs.length; ++i) {
                msgBuff.append("(" + this.errorArgs[i].getClass().getName() + ")[" + this.errorArgs[i] + "]");
                if (i >= this.errorArgs.length - 1) continue;
                msgBuff.append(", ");
            }
            msgBuff.append("]");
        }
        return msgBuff.toString();
    }
}

