/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StopWatch;

public class PerformanceMonitorInterceptor
implements MethodInterceptor {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String name = invocation.getMethod().getDeclaringClass().getName() + "." + invocation.getMethod().getName();
        this.logger.debug((Object)("Begin performance monitoring of method '" + name + "'"));
        StopWatch sw = new StopWatch(name);
        sw.start(name);
        Object rval = invocation.proceed();
        sw.stop();
        this.logger.info((Object)sw.shortSummary());
        this.logger.debug((Object)("End performance monitoring of method '" + name + "'"));
        return rval;
    }
}

