/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassLoaderUtils;

public class ClassLoaderAnalyzerInterceptor
implements MethodInterceptor {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public Object invoke(MethodInvocation pInvocation) throws Throwable {
        this.logger.debug((Object)"Begin class loader analysis");
        this.logger.info((Object)ClassLoaderUtils.showClassLoaderHierarchy(pInvocation.getThis(), pInvocation.getThis().getClass().getName(), "\n", "-"));
        Object rval = pInvocation.proceed();
        this.logger.debug((Object)"End class loader analysis");
        return rval;
    }
}

