/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.support;

import java.util.Arrays;
import java.util.HashSet;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.util.Assert;

public class CompositeConversionService
implements ConversionService {
    private ConversionService[] chain;

    public CompositeConversionService(ConversionService[] conversionServices) {
        Assert.notNull((Object)conversionServices, (String)"The conversion services chain is required");
        this.chain = conversionServices;
    }

    public ConversionService[] getConversionServices() {
        return this.chain;
    }

    public ConversionExecutor getConversionExecutor(Class sourceClass, Class targetClass) throws ConversionException {
        for (int i = 0; i < this.chain.length; ++i) {
            try {
                return this.chain[i].getConversionExecutor(sourceClass, targetClass);
            }
            catch (ConversionException e) {
                continue;
            }
        }
        throw new ConversionException(sourceClass, targetClass, "No converter registered to convert from sourceClass '" + sourceClass + "' to target class '" + targetClass + "'");
    }

    public ConversionExecutor getConversionExecutorByTargetAlias(Class sourceClass, String targetAlias) throws ConversionException {
        boolean exceptionThrown = false;
        for (int i = 0; i < this.chain.length; ++i) {
            try {
                ConversionExecutor res = this.chain[i].getConversionExecutorByTargetAlias(sourceClass, targetAlias);
                if (res == null) continue;
                return res;
            }
            catch (ConversionException e) {
                exceptionThrown = true;
            }
        }
        if (exceptionThrown) {
            throw new ConversionException(sourceClass, "No converter registered to convert from sourceClass '" + sourceClass + "' to aliased target type '" + targetAlias + "'");
        }
        return null;
    }

    public ConversionExecutor[] getConversionExecutorsForSource(Class sourceClass) throws ConversionException {
        HashSet<ConversionExecutor> executors = new HashSet<ConversionExecutor>();
        for (int i = 0; i < this.chain.length; ++i) {
            executors.addAll(Arrays.asList(this.chain[i].getConversionExecutorsForSource(sourceClass)));
        }
        return executors.toArray(new ConversionExecutor[executors.size()]);
    }

    public Class getClassByAlias(String alias) throws ConversionException {
        for (int i = 0; i < this.chain.length; ++i) {
            try {
                Class res = this.chain[i].getClassByAlias(alias);
                if (res == null) continue;
                return res;
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
        return null;
    }
}

