/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.autoconfigure;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.shell.boot.JLineShellAutoConfiguration;
import org.springframework.shell.boot.TerminalCustomizer;
import org.springframework.shell.test.autoconfigure.SpringShellTestProperties;
import org.springframework.shell.test.jediterm.terminal.TtyConnector;
import org.springframework.shell.test.jediterm.terminal.ui.JediTermWidget;
import org.springframework.shell.test.jediterm.terminal.ui.TerminalSession;

@AutoConfiguration(before={JLineShellAutoConfiguration.class})
@EnableConfigurationProperties(value={SpringShellTestProperties.class})
public class ShellAutoConfiguration {
    @Bean
    TerminalCustomizer terminalStreamsTerminalCustomizer(TerminalStreams terminalStreams) {
        return builder -> builder.streams((InputStream)terminalStreams.input, (OutputStream)terminalStreams.output).jansi(false).jna(false).jni(false);
    }

    @Bean
    TerminalStreams terminalStreams() {
        return new TerminalStreams();
    }

    @Bean
    TtyConnector ttyConnector(TerminalStreams terminalStreams) {
        return new TestTtyConnector(terminalStreams.myReader, terminalStreams.myWriter);
    }

    @Bean
    TerminalSession terminalSession(TtyConnector ttyConnector, SpringShellTestProperties properties) {
        JediTermWidget widget = new JediTermWidget(properties.getTerminalWidth(), properties.getTerminalHeight());
        widget.setTtyConnector(ttyConnector);
        return widget;
    }

    public static class TerminalStreams {
        PipedInputStream input = new PipedInputStream();
        PipedOutputStream output = new PipedOutputStream();
        InputStreamReader myReader;
        OutputStreamWriter myWriter;

        public TerminalStreams() {
            try {
                this.myReader = new InputStreamReader(new PipedInputStream(this.output));
                this.myWriter = new OutputStreamWriter(new PipedOutputStream(this.input));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class TestTtyConnector
    implements TtyConnector {
        private static final Logger log = LoggerFactory.getLogger(TestTtyConnector.class);
        InputStreamReader myReader;
        OutputStreamWriter myWriter;

        TestTtyConnector(InputStreamReader myReader, OutputStreamWriter myWriter) {
            this.myReader = myReader;
            this.myWriter = myWriter;
        }

        public boolean init() {
            return true;
        }

        public void close() {
        }

        public String getName() {
            return null;
        }

        public int read(char[] buf, int offset, int length) throws IOException {
            log.trace("read1");
            int read = this.myReader.read(buf, offset, length);
            log.trace("read2 {}", (Object)read);
            return read;
        }

        public void write(byte[] bytes) throws IOException {
            log.trace("write1 {}", (Object)bytes);
            this.myWriter.write(new String(bytes));
            this.myWriter.flush();
            log.trace("write2");
        }

        public boolean isConnected() {
            return true;
        }

        public void write(String string) throws IOException {
            this.write(string.getBytes());
        }

        public int waitFor() throws InterruptedException {
            return 0;
        }

        public boolean ready() throws IOException {
            log.trace("ready1");
            boolean ready = this.myReader.ready();
            log.trace("ready2 {}", (Object)ready);
            return ready;
        }
    }
}

