/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.table;

import java.util.ArrayList;
import org.springframework.shell.table.BorderStyle;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class BorderSpecification {
    public static final int NONE = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int INNER_VERTICAL = 16;
    public static final int INNER_HORIZONTAL = 32;
    public static final int OUTLINE = 15;
    public static final int FULL = 63;
    public static final int INNER = 48;
    private final int row1;
    private final int row2;
    private final int column1;
    private final int column2;
    private final int match;
    private final BorderStyle style;

    BorderSpecification(int row1, int column1, int row2, int column2, int match, BorderStyle style) {
        this.row1 = row1;
        this.row2 = row2;
        this.column1 = column1;
        this.column2 = column2;
        this.match = match;
        this.style = style;
    }

    char verticals(int row, int column) {
        boolean result = (this.match & 4) == 4 && column == this.column1;
        result |= (this.match & 0x10) == 16 && column > this.column1 && column < this.column2;
        result |= (this.match & 8) == 8 && column == this.column2;
        result &= row >= this.row1;
        return (result &= row < this.row2) ? this.style.verticalGlyph() : (char)'\u0000';
    }

    char horizontals(int row, int column) {
        boolean result = (this.match & 1) == 1 && row == this.row1;
        result |= (this.match & 0x20) == 32 && row > this.row1 && row < this.row2;
        result |= (this.match & 2) == 2 && row == this.row2;
        result &= column >= this.column1;
        return (result &= column < this.column2) ? this.style.horizontalGlyph() : (char)'\u0000';
    }

    public String toString() {
        return String.format("%s[(%d, %d)->(%d, %d), %s, %s]", new Object[]{this.getClass().getSimpleName(), this.row1, this.column1, this.row2, this.column2, this.style, this.matchConstants()});
    }

    private String matchConstants() {
        try {
            for (String field : new String[]{"NONE", "INNER", "FULL", "OUTLINE"}) {
                int value = ReflectionUtils.findField(this.getClass(), (String)field).getInt(null);
                if (this.match != value) continue;
                return field;
            }
            ArrayList<String> constants = new ArrayList<String>();
            for (String field : new String[]{"TOP", "BOTTOM", "LEFT", "RIGHT", "INNER_HORIZONTAL", "INNER_VERTICAL"}) {
                int value = ReflectionUtils.findField(this.getClass(), (String)field).getInt(null);
                if ((this.match & value) != value) continue;
                constants.add(field);
            }
            return StringUtils.collectionToDelimitedString(constants, (String)"|");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

