/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.table;

import java.util.ArrayList;
import org.springframework.shell.table.TextWrapper;

public class DelimiterTextWrapper
implements TextWrapper {
    private final char delimiter;

    public DelimiterTextWrapper() {
        this(' ');
    }

    public DelimiterTextWrapper(char delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public String[] wrap(String[] original, int columnWidth) {
        ArrayList<String> result = new ArrayList<String>(original.length);
        for (String line : original) {
            while (line.length() > columnWidth) {
                int split = line.lastIndexOf(this.delimiter, columnWidth);
                String toAdd = split == -1 ? line.substring(0, columnWidth) : line.substring(0, split);
                result.add(String.format("%-" + columnWidth + "s", toAdd));
                line = line.substring(split == -1 ? columnWidth : split + 1);
            }
            if (columnWidth <= 0) continue;
            result.add(String.format("%-" + columnWidth + "s", line));
        }
        return result.toArray(new String[result.size()]);
    }
}

