/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.ResolvableType;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.command.CommandOption;
import org.springframework.shell.standard.ValueProvider;

public class EnumValueProvider
implements ValueProvider {
    @Override
    public List<CompletionProposal> complete(CompletionContext completionContext) {
        T[] enumConstants;
        Class clazz;
        ResolvableType type;
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        CommandOption commandOption = completionContext.getCommandOption();
        if (commandOption != null && (type = commandOption.getType()) != null && (clazz = type.getRawClass()) != null && (enumConstants = clazz.getEnumConstants()) != null) {
            for (Object v : enumConstants) {
                Enum e = (Enum)v;
                String prefix = completionContext.currentWordUpToCursor();
                if (prefix == null) {
                    prefix = "";
                }
                if (!e.name().startsWith(prefix)) continue;
                result.add(new CompletionProposal(e.name()));
            }
        }
        return result;
    }
}

