/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.server.resource.OAuth2ProtectedResourceMetadataClaimAccessor;
import org.springframework.util.Assert;

public final class OAuth2ProtectedResourceMetadata
implements OAuth2ProtectedResourceMetadataClaimAccessor,
Serializable {
    private static final long serialVersionUID = -18589911827039000L;
    private final Map<String, Object> claims;

    private OAuth2ProtectedResourceMetadata(Map<String, Object> claims) {
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> claims = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public Builder resource(String resource) {
            return this.claim("resource", resource);
        }

        public Builder authorizationServer(String authorizationServer) {
            this.addClaimToClaimList("authorization_servers", authorizationServer);
            return this;
        }

        public Builder authorizationServers(Consumer<List<String>> authorizationServersConsumer) {
            this.acceptClaimValues("authorization_servers", authorizationServersConsumer);
            return this;
        }

        public Builder scope(String scope) {
            this.addClaimToClaimList("scopes_supported", scope);
            return this;
        }

        public Builder scopes(Consumer<List<String>> scopesConsumer) {
            this.acceptClaimValues("scopes_supported", scopesConsumer);
            return this;
        }

        public Builder bearerMethod(String bearerMethod) {
            this.addClaimToClaimList("bearer_methods_supported", bearerMethod);
            return this;
        }

        public Builder bearerMethods(Consumer<List<String>> bearerMethodsConsumer) {
            this.acceptClaimValues("bearer_methods_supported", bearerMethodsConsumer);
            return this;
        }

        public Builder resourceName(String resourceName) {
            return this.claim("resource_name", resourceName);
        }

        public Builder tlsClientCertificateBoundAccessTokens(boolean tlsClientCertificateBoundAccessTokens) {
            return this.claim("tls_client_certificate_bound_access_tokens", tlsClientCertificateBoundAccessTokens);
        }

        public Builder claim(String name, Object value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.claims.put(name, value);
            return this;
        }

        public Builder claims(Consumer<Map<String, Object>> claimsConsumer) {
            claimsConsumer.accept(this.claims);
            return this;
        }

        public OAuth2ProtectedResourceMetadata build() {
            this.validate();
            return new OAuth2ProtectedResourceMetadata(this.claims);
        }

        private void validate() {
            Assert.notNull((Object)this.claims.get("resource"), (String)"resource cannot be null");
            Builder.validateURL(this.claims.get("resource"), "resource must be a valid URL");
            if (this.claims.get("authorization_servers") != null) {
                Assert.isInstanceOf(List.class, (Object)this.claims.get("authorization_servers"), (String)"authorization_servers must be of type List");
                Assert.notEmpty((Collection)((List)this.claims.get("authorization_servers")), (String)"authorization_servers cannot be empty");
                List authorizationServers = (List)this.claims.get("authorization_servers");
                authorizationServers.forEach(authorizationServer -> Builder.validateURL(authorizationServer, "authorization_server must be a valid URL"));
            }
            if (this.claims.get("scopes_supported") != null) {
                Assert.isInstanceOf(List.class, (Object)this.claims.get("scopes_supported"), (String)"scopes must be of type List");
                Assert.notEmpty((Collection)((List)this.claims.get("scopes_supported")), (String)"scopes cannot be empty");
            }
            if (this.claims.get("bearer_methods_supported") != null) {
                Assert.isInstanceOf(List.class, (Object)this.claims.get("bearer_methods_supported"), (String)"bearer methods must be of type List");
                Assert.notEmpty((Collection)((List)this.claims.get("bearer_methods_supported")), (String)"bearer methods cannot be empty");
            }
        }

        private void addClaimToClaimList(String name, String value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.claims.computeIfAbsent(name, k -> new LinkedList());
            ((List)this.claims.get(name)).add(value);
        }

        private void acceptClaimValues(String name, Consumer<List<String>> valuesConsumer) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull(valuesConsumer, (String)"valuesConsumer cannot be null");
            this.claims.computeIfAbsent(name, k -> new LinkedList());
            List values = (List)this.claims.get(name);
            valuesConsumer.accept(values);
        }

        private static void validateURL(Object url, String errorMessage) {
            if (URL.class.isAssignableFrom(url.getClass())) {
                return;
            }
            try {
                new URI(url.toString()).toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(errorMessage, ex);
            }
        }
    }
}

