/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.kafka.support.JacksonMapperUtils;
import org.springframework.kafka.support.mapping.DefaultJacksonJavaTypeMapper;
import org.springframework.kafka.support.mapping.JacksonJavaTypeMapper;
import org.springframework.kafka.support.serializer.JacksonJsonSerializer;
import org.springframework.kafka.support.serializer.JacksonJsonTypeResolver;
import org.springframework.kafka.support.serializer.SerializationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.type.TypeFactory;

public class JacksonJsonDeserializer<T>
implements Deserializer<T> {
    public static final String KEY_DEFAULT_TYPE = "spring.json.key.default.type";
    public static final String VALUE_DEFAULT_TYPE = "spring.json.value.default.type";
    public static final String TRUSTED_PACKAGES = "spring.json.trusted.packages";
    public static final String TYPE_MAPPINGS = "spring.json.type.mapping";
    public static final String REMOVE_TYPE_INFO_HEADERS = "spring.json.remove.type.headers";
    public static final String USE_TYPE_INFO_HEADERS = "spring.json.use.type.headers";
    public static final String KEY_TYPE_METHOD = "spring.json.key.type.method";
    public static final String VALUE_TYPE_METHOD = "spring.json.value.type.method";
    private static final Set<String> OUR_KEYS = new HashSet<String>();
    protected final JsonMapper jsonMapper;
    protected @Nullable JavaType targetType;
    protected JacksonJavaTypeMapper typeMapper = new DefaultJacksonJavaTypeMapper();
    private @Nullable ObjectReader reader;
    private boolean typeMapperExplicitlySet = false;
    private boolean removeTypeHeaders = true;
    private boolean useTypeHeaders = true;
    private @Nullable JacksonJsonTypeResolver typeResolver;
    private boolean setterCalled;
    private boolean configured;
    private final Lock trustedPackagesLock = new ReentrantLock();
    private final TypeFactory typeFactory = TypeFactory.createDefaultInstance();

    public JacksonJsonDeserializer() {
        this((Class)null, true);
    }

    public JacksonJsonDeserializer(JsonMapper jsonMapper) {
        this((Class)null, jsonMapper, true);
    }

    public JacksonJsonDeserializer(@Nullable Class<? super T> targetType) {
        this(targetType, true);
    }

    public JacksonJsonDeserializer(@Nullable TypeReference<? super T> targetType) {
        this(targetType, true);
    }

    public JacksonJsonDeserializer(@Nullable JavaType targetType) {
        this(targetType, true);
    }

    public JacksonJsonDeserializer(@Nullable Class<? super T> targetType, boolean useHeadersIfPresent) {
        this(targetType, JacksonMapperUtils.enhancedJsonMapper(), useHeadersIfPresent);
    }

    public JacksonJsonDeserializer(@Nullable TypeReference<? super T> targetType, boolean useHeadersIfPresent) {
        this(targetType, JacksonMapperUtils.enhancedJsonMapper(), useHeadersIfPresent);
    }

    public JacksonJsonDeserializer(@Nullable JavaType targetType, boolean useHeadersIfPresent) {
        this(targetType, JacksonMapperUtils.enhancedJsonMapper(), useHeadersIfPresent);
    }

    public JacksonJsonDeserializer(Class<? super T> targetType, JsonMapper jsonMapper) {
        this(targetType, jsonMapper, true);
    }

    public JacksonJsonDeserializer(TypeReference<? super T> targetType, JsonMapper jsonMapper) {
        this(targetType, jsonMapper, true);
    }

    public JacksonJsonDeserializer(@Nullable JavaType targetType, JsonMapper jsonMapper) {
        this(targetType, jsonMapper, true);
    }

    public JacksonJsonDeserializer(@Nullable Class<? super T> targetType, JsonMapper jsonMapper, boolean useHeadersIfPresent) {
        Assert.notNull((Object)jsonMapper, (String)"'jsonMapper' must not be null.");
        this.jsonMapper = jsonMapper;
        JavaType javaType = null;
        if (targetType == null) {
            Class genericType = ResolvableType.forClass(this.getClass()).getSuperType().resolveGeneric(new int[]{0});
            if (genericType != null) {
                javaType = this.typeFactory.constructType((Type)genericType);
            }
        } else {
            javaType = this.typeFactory.constructType(targetType);
        }
        this.initialize(javaType, useHeadersIfPresent);
    }

    public JacksonJsonDeserializer(@Nullable TypeReference<? super T> targetType, JsonMapper jsonMapper, boolean useHeadersIfPresent) {
        this(targetType != null ? TypeFactory.createDefaultInstance().constructType(targetType) : null, jsonMapper, useHeadersIfPresent);
    }

    public JacksonJsonDeserializer(@Nullable JavaType targetType, JsonMapper jsonMapper, boolean useHeadersIfPresent) {
        Assert.notNull((Object)jsonMapper, (String)"'jsonMapper' must not be null.");
        this.jsonMapper = jsonMapper;
        this.initialize(targetType, useHeadersIfPresent);
    }

    public JacksonJavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(JacksonJavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
        this.typeMapperExplicitlySet = true;
        if (typeMapper instanceof DefaultJacksonJavaTypeMapper) {
            this.addMappingsToTrusted(((DefaultJacksonJavaTypeMapper)typeMapper).getIdClassMapping());
        }
        this.setterCalled = true;
    }

    public void setUseTypeMapperForKey(boolean isKey) {
        this.doSetUseTypeMapperForKey(isKey);
        this.setterCalled = true;
    }

    private void doSetUseTypeMapperForKey(boolean isKey) {
        if (!this.typeMapperExplicitlySet && this.getTypeMapper() instanceof DefaultJacksonJavaTypeMapper) {
            ((DefaultJacksonJavaTypeMapper)this.getTypeMapper()).setUseForKey(isKey);
        }
    }

    public void setRemoveTypeHeaders(boolean removeTypeHeaders) {
        this.removeTypeHeaders = removeTypeHeaders;
        this.setterCalled = true;
    }

    public void setUseTypeHeaders(boolean useTypeHeaders) {
        if (!this.typeMapperExplicitlySet) {
            this.useTypeHeaders = useTypeHeaders;
            this.setUpTypePrecedence(Collections.emptyMap());
        }
        this.setterCalled = true;
    }

    public void setTypeFunction(BiFunction<byte[], Headers, JavaType> typeFunction) {
        this.typeResolver = (topic, data, headers) -> (JavaType)typeFunction.apply(data, headers);
        this.setterCalled = true;
    }

    public void setTypeResolver(JacksonJsonTypeResolver typeResolver) {
        this.typeResolver = typeResolver;
        this.setterCalled = true;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            this.trustedPackagesLock.lock();
            if (this.configured) {
                return;
            }
            Assert.state((!this.setterCalled || !this.configsHasOurKeys(configs) ? 1 : 0) != 0, (String)"JsonDeserializer must be configured with property setters, or via configuration properties; not both");
            this.doSetUseTypeMapperForKey(isKey);
            this.setUpTypePrecedence(configs);
            this.setupTarget(configs, isKey);
            if (configs.containsKey(TRUSTED_PACKAGES) && configs.get(TRUSTED_PACKAGES) instanceof String) {
                this.typeMapper.addTrustedPackages(StringUtils.delimitedListToStringArray((String)((String)configs.get(TRUSTED_PACKAGES)), (String)",", (String)" \r\n\f\t"));
            }
            if (configs.containsKey(TYPE_MAPPINGS) && !this.typeMapperExplicitlySet && this.typeMapper instanceof DefaultJacksonJavaTypeMapper) {
                ((DefaultJacksonJavaTypeMapper)this.typeMapper).setIdClassMapping(this.createMappings(configs));
            }
            if (configs.containsKey(REMOVE_TYPE_INFO_HEADERS)) {
                this.removeTypeHeaders = Boolean.parseBoolean(configs.get(REMOVE_TYPE_INFO_HEADERS).toString());
            }
            this.setUpTypeMethod(configs, isKey);
            this.configured = true;
        }
        finally {
            this.trustedPackagesLock.unlock();
        }
    }

    private boolean configsHasOurKeys(Map<String, ?> configs) {
        for (String key : configs.keySet()) {
            if (!OUR_KEYS.contains(key)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Class<?>> createMappings(Map<String, ?> configs) {
        Map<String, Class<?>> mappings = JacksonJsonSerializer.createMappings(configs.get(TYPE_MAPPINGS).toString());
        this.addMappingsToTrusted(mappings);
        return mappings;
    }

    private void setUpTypeMethod(Map<String, ?> configs, boolean isKey) {
        if (isKey && configs.containsKey(KEY_TYPE_METHOD)) {
            this.setUpTypeResolver((String)configs.get(KEY_TYPE_METHOD));
        } else if (!isKey && configs.containsKey(VALUE_TYPE_METHOD)) {
            this.setUpTypeResolver((String)configs.get(VALUE_TYPE_METHOD));
        }
    }

    private void setUpTypeResolver(String method) {
        try {
            this.typeResolver = this.buildTypeResolver(method);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                this.typeResolver = (topic, data, headers) -> (JavaType)SerializationUtils.propertyToMethodInvokingFunction(method, byte[].class, this.getClass().getClassLoader()).apply(data, headers);
                return;
            }
            throw e;
        }
    }

    private void setUpTypePrecedence(Map<String, ?> configs) {
        if (!this.typeMapperExplicitlySet) {
            if (configs.containsKey(USE_TYPE_INFO_HEADERS)) {
                this.useTypeHeaders = Boolean.parseBoolean(configs.get(USE_TYPE_INFO_HEADERS).toString());
            }
            this.typeMapper.setTypePrecedence(this.useTypeHeaders ? JacksonJavaTypeMapper.TypePrecedence.TYPE_ID : JacksonJavaTypeMapper.TypePrecedence.INFERRED);
        }
    }

    private void setupTarget(Map<String, ?> configs, boolean isKey) {
        try {
            JavaType javaType = null;
            if (isKey && configs.containsKey(KEY_DEFAULT_TYPE)) {
                javaType = this.setupTargetType(configs, KEY_DEFAULT_TYPE);
            } else if (!isKey && configs.containsKey(VALUE_DEFAULT_TYPE)) {
                javaType = this.setupTargetType(configs, VALUE_DEFAULT_TYPE);
            }
            if (javaType != null) {
                this.initialize(javaType, JacksonJavaTypeMapper.TypePrecedence.TYPE_ID.equals((Object)this.typeMapper.getTypePrecedence()));
            }
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalStateException(e);
        }
    }

    private void initialize(@Nullable JavaType type, boolean useHeadersIfPresent) {
        this.targetType = type;
        this.useTypeHeaders = useHeadersIfPresent;
        Assert.isTrue((this.targetType != null || useHeadersIfPresent ? 1 : 0) != 0, (String)"'targetType' cannot be null if 'useHeadersIfPresent' is false");
        if (this.targetType != null) {
            this.reader = this.jsonMapper.readerFor(this.targetType);
        }
        this.addTargetPackageToTrusted();
        this.typeMapper.setTypePrecedence(useHeadersIfPresent ? JacksonJavaTypeMapper.TypePrecedence.TYPE_ID : JacksonJavaTypeMapper.TypePrecedence.INFERRED);
    }

    private JavaType setupTargetType(Map<String, ?> configs, String key) throws ClassNotFoundException, LinkageError {
        if (configs.get(key) instanceof Class) {
            return this.typeFactory.constructType((Type)((Class)configs.get(key)));
        }
        if (configs.get(key) instanceof String) {
            return this.typeFactory.constructType((Type)ClassUtils.forName((String)((String)configs.get(key)), null));
        }
        throw new IllegalStateException(key + " must be Class or String");
    }

    public void addTrustedPackages(String ... packages) {
        try {
            this.trustedPackagesLock.lock();
            this.doAddTrustedPackages(packages);
            this.setterCalled = true;
        }
        finally {
            this.trustedPackagesLock.unlock();
        }
    }

    private void addMappingsToTrusted(Map<String, Class<?>> mappings) {
        mappings.values().forEach(clazz -> {
            String packageName = clazz.isArray() ? clazz.getComponentType().getPackage().getName() : clazz.getPackage().getName();
            this.doAddTrustedPackages(packageName);
            this.doAddTrustedPackages(packageName + ".*");
        });
    }

    private void addTargetPackageToTrusted() {
        String targetPackageName = this.getTargetPackageName();
        if (targetPackageName != null) {
            this.doAddTrustedPackages(targetPackageName);
            this.doAddTrustedPackages(targetPackageName + ".*");
        }
    }

    private @Nullable String getTargetPackageName() {
        if (this.targetType != null) {
            return ClassUtils.getPackageName((Class)this.targetType.getRawClass()).replaceFirst("\\[L", "");
        }
        return null;
    }

    private void doAddTrustedPackages(String ... packages) {
        this.typeMapper.addTrustedPackages(packages);
    }

    public @Nullable T deserialize(String topic, Headers headers, byte @Nullable [] data) {
        if (data == null) {
            return null;
        }
        ObjectReader deserReader = null;
        JavaType javaType = null;
        if (this.typeResolver != null) {
            javaType = this.typeResolver.resolveType(topic, data, headers);
        }
        if (javaType == null && this.typeMapper.getTypePrecedence().equals((Object)JacksonJavaTypeMapper.TypePrecedence.TYPE_ID)) {
            javaType = this.typeMapper.toJavaType(headers);
        }
        if (javaType != null) {
            deserReader = this.jsonMapper.readerFor(javaType);
        }
        if (this.removeTypeHeaders) {
            this.typeMapper.removeHeaders(headers);
        }
        if (deserReader == null) {
            deserReader = this.reader;
        }
        Assert.state((deserReader != null ? 1 : 0) != 0, (String)"No type information in headers and no default type provided");
        try {
            return (T)deserReader.readValue(data);
        }
        catch (Exception ex) {
            throw new SerializationException("Can't deserialize data  from topic [" + topic + "]", (Throwable)ex);
        }
    }

    public @Nullable T deserialize(String topic, byte @Nullable [] data) {
        JavaType javaType;
        if (data == null) {
            return null;
        }
        ObjectReader localReader = this.reader;
        if (this.typeResolver != null && (javaType = this.typeResolver.resolveType(topic, data, null)) != null) {
            localReader = this.jsonMapper.readerFor(javaType);
        }
        Assert.state((localReader != null ? 1 : 0) != 0, (String)"No headers available and no default type provided");
        try {
            return (T)localReader.readValue(data);
        }
        catch (Exception e) {
            throw new SerializationException("Can't deserialize data [" + Arrays.toString(data) + "] from topic [" + topic + "]", (Throwable)e);
        }
    }

    public void close() {
    }

    public <X> JacksonJsonDeserializer<X> copyWithType(Class<? super X> newTargetType) {
        return this.copyWithType(this.jsonMapper.constructType(newTargetType));
    }

    public <X> JacksonJsonDeserializer<X> copyWithType(TypeReference<? super X> newTargetType) {
        return this.copyWithType(this.jsonMapper.constructType(newTargetType.getType()));
    }

    public <X> JacksonJsonDeserializer<X> copyWithType(JavaType newTargetType) {
        JacksonJsonDeserializer<T> result = new JacksonJsonDeserializer<T>(newTargetType, this.jsonMapper, this.useTypeHeaders);
        result.removeTypeHeaders = this.removeTypeHeaders;
        result.typeMapper = this.typeMapper;
        result.typeMapperExplicitlySet = this.typeMapperExplicitlySet;
        return result;
    }

    public JacksonJsonDeserializer<T> forKeys() {
        this.setUseTypeMapperForKey(true);
        return this;
    }

    public JacksonJsonDeserializer<T> dontRemoveTypeHeaders() {
        this.setRemoveTypeHeaders(false);
        return this;
    }

    public JacksonJsonDeserializer<T> ignoreTypeHeaders() {
        this.setUseTypeHeaders(false);
        return this;
    }

    public JacksonJsonDeserializer<T> typeMapper(JacksonJavaTypeMapper mapper) {
        this.setTypeMapper(mapper);
        return this;
    }

    public JacksonJsonDeserializer<T> trustedPackages(String ... packages) {
        try {
            this.trustedPackagesLock.lock();
            Assert.isTrue((!this.typeMapperExplicitlySet ? 1 : 0) != 0, (String)"When using a custom type mapper, set the trusted packages there");
            this.typeMapper.addTrustedPackages(packages);
            JacksonJsonDeserializer jacksonJsonDeserializer = this;
            return jacksonJsonDeserializer;
        }
        finally {
            this.trustedPackagesLock.unlock();
        }
    }

    public JacksonJsonDeserializer<T> typeFunction(BiFunction<byte[], Headers, JavaType> typeFunction) {
        this.setTypeFunction(typeFunction);
        return this;
    }

    public JacksonJsonDeserializer<T> typeResolver(JacksonJsonTypeResolver resolver) {
        this.setTypeResolver(resolver);
        return this;
    }

    private JacksonJsonTypeResolver buildTypeResolver(String methodProperty) {
        Method method;
        Class clazz;
        int lastDotPosn = methodProperty.lastIndexOf(46);
        Assert.state((lastDotPosn > 1 ? 1 : 0) != 0, (String)"the method property needs to be a class name followed by the method name, separated by '.'");
        try {
            clazz = ClassUtils.forName((String)methodProperty.substring(0, lastDotPosn), (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalStateException(e);
        }
        String methodName = methodProperty.substring(lastDotPosn + 1);
        try {
            method = clazz.getDeclaredMethod(methodName, String.class, byte[].class, Headers.class);
            Assert.state((boolean)JavaType.class.isAssignableFrom(method.getReturnType()), (String)(String.valueOf(method) + " return type must be JavaType"));
            Assert.state((boolean)Modifier.isStatic(method.getModifiers()), (String)(String.valueOf(method) + " must be static"));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        return (topic, data, headers) -> {
            try {
                return (JavaType)method.invoke(null, topic, data, headers);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        };
    }

    static {
        OUR_KEYS.add(KEY_DEFAULT_TYPE);
        OUR_KEYS.add(VALUE_DEFAULT_TYPE);
        OUR_KEYS.add(TRUSTED_PACKAGES);
        OUR_KEYS.add(TYPE_MAPPINGS);
        OUR_KEYS.add(REMOVE_TYPE_INFO_HEADERS);
        OUR_KEYS.add(USE_TYPE_INFO_HEADERS);
        OUR_KEYS.add(KEY_TYPE_METHOD);
        OUR_KEYS.add(VALUE_TYPE_METHOD);
    }
}

