/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.event;

import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.event.KafkaEvent;

public class ListenerContainerPartitionNoLongerIdleEvent
extends KafkaEvent {
    private static final long serialVersionUID = 1L;
    private final long idleTime;
    private final String listenerId;
    private final TopicPartition topicPartition;
    private transient Consumer<?, ?> consumer;

    public ListenerContainerPartitionNoLongerIdleEvent(Object source, Object container, long idleTime, String id, TopicPartition topicPartition, Consumer<?, ?> consumer) {
        super(source, container);
        this.idleTime = idleTime;
        this.listenerId = id;
        this.topicPartition = topicPartition;
        this.consumer = consumer;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public Consumer<?, ?> getConsumer() {
        return this.consumer;
    }

    public String toString() {
        return "ListenerContainerPartitionNoLongerIdleEvent [idleTime=" + (float)this.idleTime / 1000.0f + "s, listenerId=" + this.listenerId + ", container=" + this.getSource() + ", topicPartition=" + this.topicPartition + "]";
    }
}

