/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.micrometer;

import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.springframework.kafka.support.micrometer.KafkaListenerObservationConvention;
import org.springframework.kafka.support.micrometer.KafkaRecordReceiverContext;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum KafkaListenerObservation implements ObservationDocumentation
{
    LISTENER_OBSERVATION{

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultKafkaListenerObservationConvention.class;
        }

        public String getPrefix() {
            return "spring.kafka.listener";
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return ListenerLowCardinalityTags.values();
        }
    };


    public static class DefaultKafkaListenerObservationConvention
    implements KafkaListenerObservationConvention {
        public static final DefaultKafkaListenerObservationConvention INSTANCE = new DefaultKafkaListenerObservationConvention();

        public KeyValues getLowCardinalityKeyValues(KafkaRecordReceiverContext context) {
            return KeyValues.of((String)ListenerLowCardinalityTags.LISTENER_ID.asString(), (String)context.getListenerId());
        }

        public String getContextualName(KafkaRecordReceiverContext context) {
            return context.getSource() + " receive";
        }

        @Override
        public String getName() {
            return "spring.kafka.listener";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ListenerLowCardinalityTags implements KeyName
    {
        LISTENER_ID{

            public String asString() {
                return "spring.kafka.listener.id";
            }
        };

    }
}

