/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.springframework.kafka.support.AbstractKafkaHeaderMapper;
import org.springframework.messaging.MessageHeaders;

public class SimpleKafkaHeaderMapper
extends AbstractKafkaHeaderMapper {
    private static final Set<String> NEVER = new HashSet<String>();

    public SimpleKafkaHeaderMapper() {
        super("!id", "!timestamp", "*");
    }

    public SimpleKafkaHeaderMapper(String ... patterns) {
        this(true, patterns);
    }

    private SimpleKafkaHeaderMapper(boolean outbound, String ... patterns) {
        super(outbound, patterns);
    }

    public static SimpleKafkaHeaderMapper forInboundOnlyWithMatchers(String ... patterns) {
        return new SimpleKafkaHeaderMapper(false, patterns);
    }

    @Override
    public void fromHeaders(MessageHeaders headers, Headers target) {
        headers.forEach((key, value) -> {
            Object valueToAdd;
            if (!NEVER.contains(key) && (valueToAdd = this.headerValueToAddOut((String)key, value)) instanceof byte[] && this.matches((String)key, valueToAdd)) {
                target.add((Header)new RecordHeader(key, (byte[])valueToAdd));
            }
        });
    }

    @Override
    public void toHeaders(Headers source, Map<String, Object> target) {
        source.forEach(header -> {
            String headerName = header.key();
            if (this.matchesForInbound(headerName)) {
                if (headerName.equals("kafka_deliveryAttempt")) {
                    target.put(headerName, ByteBuffer.wrap(header.value()).getInt());
                } else {
                    target.put(headerName, this.headerValueToAddIn((Header)header));
                }
            }
        });
    }

    static {
        NEVER.add("kafka_deliveryAttempt");
        NEVER.add("kafka_listenerInfo");
    }
}

