/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.retry.RetryOperations;
import org.springframework.util.Assert;

public class RetryingDeserializer<T>
implements Deserializer<T> {
    private final Deserializer<T> delegate;
    private final RetryOperations retryOperations;

    public RetryingDeserializer(Deserializer<T> delegate, RetryOperations retryOperations) {
        Assert.notNull(delegate, (String)"the 'delegate' deserializer cannot be null");
        Assert.notNull((Object)retryOperations, (String)"the 'retryOperations' deserializer cannot be null");
        this.delegate = delegate;
        this.retryOperations = retryOperations;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.delegate.configure(configs, isKey);
    }

    public T deserialize(String topic, byte[] data) {
        return (T)this.retryOperations.execute(context -> this.delegate.deserialize(topic, data));
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        return (T)this.retryOperations.execute(context -> this.delegate.deserialize(topic, headers, data));
    }

    public void close() {
        this.delegate.close();
    }
}

