/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class LoggingProducerListener<K, V>
implements ProducerListener<K, V> {
    public static final int DEFAULT_MAX_CONTENT_LOGGED = 100;
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(LoggingProducerListener.class));
    private boolean includeContents = true;
    private int maxContentLogged = 100;

    public void setIncludeContents(boolean includeContents) {
        this.includeContents = includeContents;
    }

    public void setMaxContentLogged(int maxContentLogged) {
        this.maxContentLogged = maxContentLogged;
    }

    @Override
    public void onError(ProducerRecord<K, V> record, @Nullable RecordMetadata recordMetadata, Exception exception) {
        LOGGER.error((Throwable)exception, () -> {
            StringBuffer logOutput = new StringBuffer();
            logOutput.append("Exception thrown when sending a message");
            if (this.includeContents) {
                logOutput.append(" with key='").append(this.toDisplayString(ObjectUtils.nullSafeToString((Object)record.key()), this.maxContentLogged)).append("'").append(" and payload='").append(this.toDisplayString(ObjectUtils.nullSafeToString((Object)record.value()), this.maxContentLogged)).append("'");
            }
            logOutput.append(" to topic ").append(record.topic());
            if (record.partition() != null) {
                logOutput.append(" and partition ").append(recordMetadata != null ? recordMetadata.partition() : record.partition().intValue());
            }
            logOutput.append(":");
            return logOutput.toString();
        });
    }

    private String toDisplayString(String original, int maxCharacters) {
        if (original.length() <= maxCharacters) {
            return original;
        }
        return original.substring(0, maxCharacters) + "...";
    }
}

