/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.NewTopic;

public final class TopicBuilder {
    private final String name;
    private Optional<Integer> partitions = Optional.empty();
    private Optional<Short> replicas = Optional.empty();
    private Map<Integer, List<Integer>> replicasAssignments;
    private final Map<String, String> configs = new HashMap<String, String>();

    private TopicBuilder(String name) {
        this.name = name;
    }

    public TopicBuilder partitions(int partitionCount) {
        this.partitions = Optional.of(partitionCount);
        return this;
    }

    public TopicBuilder replicas(int replicaCount) {
        this.replicas = Optional.of((short)replicaCount);
        return this;
    }

    public TopicBuilder replicasAssignments(Map<Integer, List<Integer>> replicaAssignments) {
        replicaAssignments.forEach((part, list) -> this.assignReplicas((int)part, (List<Integer>)list));
        return this;
    }

    public TopicBuilder assignReplicas(int partition, List<Integer> replicaList) {
        if (this.replicasAssignments == null) {
            this.replicasAssignments = new HashMap<Integer, List<Integer>>();
        }
        this.replicasAssignments.put(partition, new ArrayList<Integer>(replicaList));
        return this;
    }

    public TopicBuilder configs(Map<String, String> configProps) {
        this.configs.putAll(configProps);
        return this;
    }

    public TopicBuilder config(String configName, String configValue) {
        this.configs.put(configName, configValue);
        return this;
    }

    public TopicBuilder compact() {
        this.configs.put("cleanup.policy", "compact");
        return this;
    }

    public NewTopic build() {
        NewTopic topic;
        NewTopic newTopic = topic = this.replicasAssignments == null ? new NewTopic(this.name, this.partitions, this.replicas) : new NewTopic(this.name, this.replicasAssignments);
        if (this.configs.size() > 0) {
            topic.configs(this.configs);
        }
        return topic;
    }

    public static TopicBuilder name(String name) {
        return new TopicBuilder(name);
    }
}

