/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.context;

import java.util.Arrays;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.test.context.SpringIntegrationTest;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

class IntegrationEndpointsInitializer
implements SmartInitializingSingleton,
BeanPostProcessor,
BeanFactoryAware {
    private final String[] patterns;
    private ConfigurableListableBeanFactory beanFactory;

    IntegrationEndpointsInitializer(SpringIntegrationTest springIntegrationTest) {
        this.patterns = springIntegrationTest.noAutoStartup();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory);
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AbstractEndpoint && ((AbstractEndpoint)bean).isAutoStartup() && this.match(beanName)) {
            ((AbstractEndpoint)bean).setAutoStartup(false);
        }
        return bean;
    }

    public void afterSingletonsInstantiated() {
        this.beanFactory.getBeansOfType(AbstractEndpoint.class).entrySet().stream().filter(entry -> ((AbstractEndpoint)entry.getValue()).isAutoStartup() && this.match((String)entry.getKey())).forEach(entry -> ((AbstractEndpoint)entry.getValue()).setAutoStartup(false));
    }

    private boolean match(String name) {
        return Arrays.stream(this.patterns).anyMatch(pattern -> PatternMatchUtils.simpleMatch((String)pattern, (String)name));
    }
}

