/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.store;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.predicates.SqlPredicate;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.integration.store.AbstractKeyValueMessageStore;
import org.springframework.util.Assert;

public class HazelcastMessageStore
extends AbstractKeyValueMessageStore {
    private static final String MESSAGE_STORE_MAP_NAME = "SPRING_INTEGRATION_MESSAGE_STORE";
    private final IMap<Object, Object> map;

    public HazelcastMessageStore(HazelcastInstance hazelcastInstance) {
        Assert.notNull((Object)hazelcastInstance, (String)"Hazelcast instance can't be null");
        this.map = hazelcastInstance.getMap(MESSAGE_STORE_MAP_NAME);
    }

    public HazelcastMessageStore(IMap<Object, Object> map) {
        Assert.notNull(map, (String)"IMap reference can not be null");
        this.map = map;
    }

    protected Object doRetrieve(Object id) {
        return this.map.get(id);
    }

    protected void doStore(Object id, Object objectToStore) {
        this.map.put(id, objectToStore);
    }

    protected void doStoreIfAbsent(Object id, Object objectToStore) {
        this.map.putIfAbsent(id, objectToStore);
    }

    protected void doRemoveAll(Collection<Object> ids) {
        this.map.removeAll((Predicate & Serializable)mapEntry -> ids.contains(mapEntry.getKey()));
    }

    protected Object doRemove(Object id) {
        return this.map.remove(id);
    }

    protected Collection<?> doListKeys(String keyPattern) {
        Assert.hasText((String)keyPattern, (String)"'keyPattern' must not be empty");
        keyPattern = keyPattern.replaceAll("\\*", "%");
        SqlPredicate sqlPredicate = new SqlPredicate("__key like " + keyPattern);
        return this.map.values((Predicate)sqlPredicate);
    }
}

