/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.metadata;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.metadata.ListenableMetadataStore;
import org.springframework.integration.metadata.MetadataStoreListener;
import org.springframework.util.Assert;

public class HazelcastMetadataStore
implements ListenableMetadataStore,
InitializingBean {
    private static final String METADATA_STORE_MAP_NAME = "SPRING_INTEGRATION_METADATA_STORE";
    private final IMap<String, String> map;
    private final List<MetadataStoreListener> listeners = new CopyOnWriteArrayList<MetadataStoreListener>();

    public HazelcastMetadataStore(HazelcastInstance hazelcastInstance) {
        Assert.notNull((Object)hazelcastInstance, (String)"Hazelcast instance can't be null");
        this.map = hazelcastInstance.getMap(METADATA_STORE_MAP_NAME);
    }

    public HazelcastMetadataStore(IMap<String, String> map) {
        Assert.notNull(map, (String)"IMap reference can not be null");
        this.map = map;
    }

    public String putIfAbsent(String key, String value) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)value, (String)"'value' must not be null.");
        return (String)this.map.putIfAbsent((Object)key, (Object)value);
    }

    public boolean replace(String key, String oldValue, String newValue) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)oldValue, (String)"'oldValue' must not be null.");
        Assert.notNull((Object)newValue, (String)"'newValue' must not be null.");
        return this.map.replace((Object)key, (Object)oldValue, (Object)newValue);
    }

    public void put(String key, String value) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)value, (String)"'value' must not be null.");
        this.map.put((Object)key, (Object)value);
    }

    public String get(String key) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        return (String)this.map.get((Object)key);
    }

    public String remove(String key) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        return (String)this.map.remove((Object)key);
    }

    public void addListener(MetadataStoreListener callback) {
        Assert.notNull((Object)callback, (String)"callback object can not be null");
        this.listeners.add(callback);
    }

    public void removeListener(MetadataStoreListener callback) {
        this.listeners.remove(callback);
    }

    public void afterPropertiesSet() throws Exception {
        this.map.addEntryListener((com.hazelcast.map.listener.MapListener)new MapListener(this.listeners), true);
    }

    private static class MapListener
    implements EntryAddedListener<String, String>,
    EntryRemovedListener<String, String>,
    EntryUpdatedListener<String, String> {
        private final List<MetadataStoreListener> listeners;

        MapListener(List<MetadataStoreListener> listeners) {
            this.listeners = listeners;
        }

        public void entryAdded(EntryEvent<String, String> event) {
            for (MetadataStoreListener listener : this.listeners) {
                listener.onAdd((String)event.getKey(), (String)event.getValue());
            }
        }

        public void entryRemoved(EntryEvent<String, String> event) {
            for (MetadataStoreListener listener : this.listeners) {
                listener.onRemove((String)event.getKey(), (String)event.getOldValue());
            }
        }

        public void entryUpdated(EntryEvent<String, String> event) {
            for (MetadataStoreListener listener : this.listeners) {
                listener.onUpdate((String)event.getKey(), (String)event.getValue());
            }
        }
    }
}

