/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.leader;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.lock.FencedLock;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.Context;
import org.springframework.integration.leader.DefaultCandidate;
import org.springframework.integration.leader.event.DefaultLeaderEventPublisher;
import org.springframework.integration.leader.event.LeaderEventPublisher;
import org.springframework.util.Assert;

public class LeaderInitiator
implements SmartLifecycle,
DisposableBean,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog(LeaderInitiator.class);
    private static int threadNameCount = 0;
    private static final Context NULL_CONTEXT = new NullContext();
    private final HazelcastInstance client;
    private final Candidate candidate;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "Hazelcast-leadership-" + threadNameCount++);
        thread.setDaemon(true);
        return thread;
    });
    private long heartBeatMillis = 500L;
    private long busyWaitMillis = 50L;
    private LeaderSelector leaderSelector;
    private LeaderEventPublisher leaderEventPublisher = new DefaultLeaderEventPublisher();
    private boolean autoStartup = true;
    private int phase;
    private volatile Future<Void> future;
    private volatile FencedLock lock;
    private boolean customPublisher = false;
    private volatile boolean running;

    public LeaderInitiator(HazelcastInstance client) {
        this(client, (Candidate)new DefaultCandidate());
    }

    public LeaderInitiator(HazelcastInstance client, Candidate candidate) {
        Assert.notNull((Object)client, (String)"'client' must not be null");
        Assert.notNull((Object)candidate, (String)"'candidate' must not be null");
        this.client = client;
        this.candidate = candidate;
    }

    public void setLeaderEventPublisher(LeaderEventPublisher leaderEventPublisher) {
        Assert.notNull((Object)leaderEventPublisher, (String)"'leaderEventPublisher' must not be null");
        this.leaderEventPublisher = leaderEventPublisher;
        this.customPublisher = true;
    }

    public void setHeartBeatMillis(long heartBeatMillis) {
        this.heartBeatMillis = heartBeatMillis;
    }

    public void setBusyWaitMillis(long busyWaitMillis) {
        this.busyWaitMillis = busyWaitMillis;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        if (!this.customPublisher) {
            this.leaderEventPublisher = new DefaultLeaderEventPublisher(applicationEventPublisher);
        }
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public Context getContext() {
        if (this.leaderSelector == null) {
            return NULL_CONTEXT;
        }
        return this.leaderSelector.context;
    }

    public synchronized void start() {
        if (!this.running) {
            this.lock = this.client.getCPSubsystem().getLock(this.candidate.getRole());
            this.leaderSelector = new LeaderSelector();
            this.running = true;
            this.future = this.executorService.submit(this.leaderSelector);
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            if (this.future != null) {
                this.future.cancel(true);
            }
            this.future = null;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void destroy() {
        this.stop();
        this.executorService.shutdown();
    }

    private static final class NullContext
    implements Context {
        private NullContext() {
        }

        public boolean isLeader() {
            return false;
        }

        public void yield() {
        }
    }

    protected class HazelcastContext
    implements Context {
        protected HazelcastContext() {
        }

        public boolean isLeader() {
            return LeaderInitiator.this.leaderSelector.locked;
        }

        public void yield() {
            if (LeaderInitiator.this.future != null) {
                LeaderInitiator.this.future.cancel(true);
            }
        }

        public String toString() {
            return "HazelcastContext{role=" + LeaderInitiator.this.candidate.getRole() + ", id=" + LeaderInitiator.this.candidate.getId() + ", isLeader=" + this.isLeader() + "}";
        }
    }

    protected class LeaderSelector
    implements Callable<Void> {
        protected final HazelcastContext context;
        protected final String role;
        private volatile boolean locked;

        protected LeaderSelector() {
            this.context = new HazelcastContext();
            this.role = LeaderInitiator.this.candidate.getRole();
            this.locked = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void call() {
            block16: while (true) {
                while (LeaderInitiator.this.isRunning()) {
                    try {
                        if (LeaderInitiator.this.lock.isLocked()) {
                            Thread.sleep(LeaderInitiator.this.heartBeatMillis);
                            continue block16;
                        }
                        boolean acquired = LeaderInitiator.this.lock.tryLock(LeaderInitiator.this.heartBeatMillis, TimeUnit.MILLISECONDS);
                        if (this.locked || !acquired) continue block16;
                        this.locked = true;
                        this.handleGranted();
                    }
                    catch (Exception e) {
                        if (this.locked) {
                            this.locked = false;
                            try {
                                LeaderInitiator.this.lock.unlock();
                            }
                            catch (Exception e1) {
                                logger.debug((Object)("Could not unlock - treat as broken " + this.context + ". Revoking " + (LeaderInitiator.this.isRunning() ? " and retrying..." : "...")), (Throwable)e1);
                            }
                            this.handleRevoked();
                        }
                        if (e instanceof InterruptedException || Thread.currentThread().isInterrupted()) {
                            Thread.currentThread().interrupt();
                            if (LeaderInitiator.this.isRunning()) {
                                logger.warn((Object)("Restarting LeaderSelector for " + this.context + " because of error."), (Throwable)e);
                                LeaderInitiator.this.future = LeaderInitiator.this.executorService.submit(() -> {
                                    Thread.sleep(LeaderInitiator.this.busyWaitMillis);
                                    return this.call();
                                });
                            }
                            Void e1 = null;
                            if (!this.locked) return e1;
                            this.locked = false;
                            try {
                                LeaderInitiator.this.lock.unlock();
                            }
                            catch (Exception e2) {
                                logger.debug((Object)("Could not unlock during stop for " + this.context + " - treat as broken. Revoking..."), (Throwable)e2);
                            }
                            this.handleRevoked();
                            return e1;
                        }
                        try {
                            if (LeaderInitiator.this.isRunning()) {
                                try {
                                    Thread.sleep(LeaderInitiator.this.busyWaitMillis);
                                }
                                catch (InterruptedException e1) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            if (!logger.isDebugEnabled()) continue block16;
                            logger.debug((Object)("Error acquiring the lock for " + this.context + ". " + (LeaderInitiator.this.isRunning() ? "Retrying..." : "")), (Throwable)e);
                            continue block16;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return null;
                        }
                    }
                }
            }
            finally {
                if (this.locked) {
                    this.locked = false;
                    try {
                        LeaderInitiator.this.lock.unlock();
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Could not unlock during stop for " + this.context + " - treat as broken. Revoking..."), (Throwable)e);
                    }
                    this.handleRevoked();
                }
            }
        }

        private void handleGranted() throws InterruptedException {
            LeaderInitiator.this.candidate.onGranted((Context)this.context);
            if (LeaderInitiator.this.leaderEventPublisher != null) {
                try {
                    LeaderInitiator.this.leaderEventPublisher.publishOnGranted((Object)LeaderInitiator.this, (Context)this.context, this.role);
                }
                catch (Exception e) {
                    logger.warn((Object)"Error publishing OnGranted event.", (Throwable)e);
                }
            }
        }

        private void handleRevoked() {
            LeaderInitiator.this.candidate.onRevoked((Context)this.context);
            if (LeaderInitiator.this.leaderEventPublisher != null) {
                try {
                    LeaderInitiator.this.leaderEventPublisher.publishOnRevoked((Object)LeaderInitiator.this, (Context)this.context, this.role);
                }
                catch (Exception e) {
                    logger.warn((Object)"Error publishing OnRevoked event.", (Throwable)e);
                }
            }
        }
    }
}

