/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.config.xml;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.hazelcast.inbound.HazelcastDistributedSQLMessageSource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class HazelcastDistributedSQLInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    private static final String CACHE_ATTRIBUTE = "cache";
    private static final String DISTRIBUTED_SQL_ATTRIBUTE = "distributed-sql";
    private static final String ITERATION_TYPE_ATTRIBUTE = "iteration-type";

    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        if (!StringUtils.hasText((String)element.getAttribute(CACHE_ATTRIBUTE))) {
            parserContext.getReaderContext().error("'cache' attribute is required.", (Object)element);
        } else if (!StringUtils.hasText((String)element.getAttribute(DISTRIBUTED_SQL_ATTRIBUTE))) {
            parserContext.getReaderContext().error("'distributed-sql' attribute is required.", (Object)element);
        } else if (!StringUtils.hasText((String)element.getAttribute(ITERATION_TYPE_ATTRIBUTE))) {
            parserContext.getReaderContext().error("'iteration-type' attribute is required.", (Object)element);
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)HazelcastDistributedSQLMessageSource.class.getName());
        builder.addConstructorArgReference(element.getAttribute(CACHE_ATTRIBUTE));
        builder.addConstructorArgValue((Object)element.getAttribute(DISTRIBUTED_SQL_ATTRIBUTE));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)ITERATION_TYPE_ATTRIBUTE);
        return builder.getBeanDefinition();
    }
}

