/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.config.xml;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.hazelcast.inbound.HazelcastClusterMonitorMessageProducer;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class HazelcastClusterMonitorInboundChannelAdapterParser
extends AbstractSingleBeanDefinitionParser {
    private static final String CHANNEL_ATTRIBUTE = "channel";
    private static final String HAZELCAST_INSTANCE_ATTRIBUTE = "hazelcast-instance";
    private static final String MONITOR_TYPES_ATTRIBUTE = "monitor-types";
    private static final String OUTPUT_CHANNEL = "outputChannel";
    private static final String MONITOR_EVENT_TYPES = "monitorEventTypes";

    protected Class<?> getBeanClass(Element element) {
        return HazelcastClusterMonitorMessageProducer.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (!element.hasAttribute(CHANNEL_ATTRIBUTE)) {
            id = id + ".adapter";
        }
        if (!StringUtils.hasText((String)id)) {
            id = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        return id;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String channelName = element.getAttribute(CHANNEL_ATTRIBUTE);
        if (!StringUtils.hasText((String)channelName)) {
            channelName = IntegrationNamespaceUtils.createDirectChannel((Element)element, (ParserContext)parserContext);
        }
        if (!StringUtils.hasText((String)element.getAttribute(HAZELCAST_INSTANCE_ATTRIBUTE))) {
            parserContext.getReaderContext().error("'hazelcast-instance' attribute is required.", (Object)element);
        }
        builder.addPropertyReference(OUTPUT_CHANNEL, channelName);
        builder.addConstructorArgReference(element.getAttribute(HAZELCAST_INSTANCE_ATTRIBUTE));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)MONITOR_TYPES_ATTRIBUTE, (String)MONITOR_EVENT_TYPES);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"phase");
    }
}

