/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast;

import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.multimap.MultiMap;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.integration.hazelcast.listener.HazelcastMembershipListener;

public class HazelcastLocalInstanceRegistrar
implements SmartInitializingSingleton {
    private static final Log logger = LogFactory.getLog(HazelcastLocalInstanceRegistrar.class);
    public static final String BEAN_NAME = "hazelcastLocalInstanceRegistrar";
    public static final String SPRING_INTEGRATION_INTERNAL_CLUSTER_MULTIMAP = "SPRING_INTEGRATION_INTERNAL_CLUSTER_MULTIMAP";
    public static final String SPRING_INTEGRATION_INTERNAL_CLUSTER_LOCK = "SPRING_INTEGRATION_INTERNAL_CLUSTER_LOCK";
    private final HazelcastInstance hazelcastInstance;

    public HazelcastLocalInstanceRegistrar() {
        this.hazelcastInstance = null;
    }

    public HazelcastLocalInstanceRegistrar(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public void afterSingletonsInstantiated() {
        if (this.hazelcastInstance == null) {
            if (!Hazelcast.getAllHazelcastInstances().isEmpty()) {
                HazelcastInstance hazelcastInstance = (HazelcastInstance)Hazelcast.getAllHazelcastInstances().iterator().next();
                hazelcastInstance.getCluster().addMembershipListener((MembershipListener)new HazelcastMembershipListener());
                this.syncConfigurationMultiMap(hazelcastInstance);
            } else {
                logger.warn((Object)"No HazelcastInstances for MembershipListener registration");
            }
        } else {
            this.syncConfigurationMultiMap(this.hazelcastInstance);
            this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)new HazelcastMembershipListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncConfigurationMultiMap(HazelcastInstance hazelcastInstance) {
        FencedLock lock = hazelcastInstance.getCPSubsystem().getLock(SPRING_INTEGRATION_INTERNAL_CLUSTER_LOCK);
        lock.lock();
        try {
            MultiMap multiMap = hazelcastInstance.getMultiMap(SPRING_INTEGRATION_INTERNAL_CLUSTER_MULTIMAP);
            for (HazelcastInstance localInstance : Hazelcast.getAllHazelcastInstances()) {
                SocketAddress localInstanceSocketAddress = localInstance.getLocalEndpoint().getSocketAddress();
                if (multiMap.size() == 0) {
                    multiMap.put((Object)localInstanceSocketAddress, (Object)localInstanceSocketAddress);
                    continue;
                }
                multiMap.put(multiMap.keySet().iterator().next(), (Object)localInstanceSocketAddress);
            }
        }
        finally {
            lock.unlock();
        }
    }
}

