/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gemfire.config.xml;

import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.gemfire.outbound.CacheWritingMessageHandler;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GemfireOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    private static final String CACHE_ENTRIES_PROPERTY = "cacheEntries";
    private static final String CACHE_ENTRIES_ELEMENT = "cache-entries";
    private static final String REGION_ATTRIBUTE = "region";

    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder cacheWritingMessageHandler = BeanDefinitionBuilder.genericBeanDefinition(CacheWritingMessageHandler.class);
        if (!element.hasAttribute(REGION_ATTRIBUTE)) {
            parserContext.getReaderContext().error("'region' attribute is required.", (Object)element);
        }
        cacheWritingMessageHandler.addConstructorArgReference(element.getAttribute(REGION_ATTRIBUTE));
        Element cacheEntries = DomUtils.getChildElementByTagName((Element)element, (String)CACHE_ENTRIES_ELEMENT);
        if (cacheEntries != null) {
            Map map = parserContext.getDelegate().parseMapElement(cacheEntries, (BeanDefinition)cacheWritingMessageHandler.getBeanDefinition());
            cacheWritingMessageHandler.addPropertyValue(CACHE_ENTRIES_PROPERTY, (Object)map);
        }
        return cacheWritingMessageHandler.getBeanDefinition();
    }
}

