/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.support;

import java.util.HashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.core.AttributeAccessor;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.ErrorMessage;

public class AmqpMessageHeaderErrorMessageStrategy
implements ErrorMessageStrategy {
    public static final String AMQP_RAW_MESSAGE = "amqp_raw_message";

    public ErrorMessage buildErrorMessage(Throwable throwable, @Nullable AttributeAccessor context) {
        Object amqpRawMessage;
        Object inputMessage = context == null ? null : context.getAttribute("inputMessage");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (context != null && (amqpRawMessage = context.getAttribute(AMQP_RAW_MESSAGE)) != null) {
            headers.put(AMQP_RAW_MESSAGE, amqpRawMessage);
            headers.put("sourceData", amqpRawMessage);
        }
        if (inputMessage instanceof Message) {
            return new ErrorMessage(throwable, headers, (Message)inputMessage);
        }
        return new ErrorMessage(throwable, headers);
    }
}

