/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.uber;

import com.fasterxml.jackson.databind.Module;
import java.util.Collections;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.mediatype.uber.Jackson2UberModule;
import org.springframework.hateoas.mediatype.uber.UberLinkDiscoverer;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;

@Configuration(proxyBeanMethods=false)
class UberMediaTypeConfiguration
implements HypermediaMappingInformation {
    UberMediaTypeConfiguration() {
    }

    @Bean
    LinkDiscoverer uberLinkDiscoverer() {
        return new UberLinkDiscoverer();
    }

    @Override
    public List<MediaType> getMediaTypes() {
        return Collections.singletonList(EnableHypermediaSupport.HypermediaType.UBER.getMediaType());
    }

    @Override
    @NonNull
    public Module getJacksonModule() {
        return new Jackson2UberModule();
    }
}

