/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.aot;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpEntity;

class AotUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AotUtils.class);
    private static final List<Class<?>> MODEL_TYPES = List.of(EntityModel.class, CollectionModel.class);
    private static final Set<Class<?>> SEEN_TYPES = new HashSet();

    AotUtils() {
    }

    public static void registerModelDomainTypesForReflection(ResolvableType type, ReflectionHints reflection, Class<?> context) {
        if (HttpEntity.class.isAssignableFrom(type.resolve(Object.class))) {
            AotUtils.registerModelDomainTypesForReflection(type.as(HttpEntity.class).getGeneric(new int[]{0}), reflection, context);
        }
        MODEL_TYPES.stream().flatMap(it -> AotUtils.extractGenerics(it, type).stream()).forEach(it -> AotUtils.registerTypeForReflection(it, reflection, context));
    }

    public static void registerTypeForReflection(Class<?> type, ReflectionHints reflection, Class<?> context) {
        if (SEEN_TYPES.contains(type)) {
            return;
        }
        LOGGER.info("Registering {} for reflection (for {})", (Object)type.getName(), (Object)context.getName());
        reflection.registerType(type, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS});
        SEEN_TYPES.add(type);
    }

    private static Optional<Class<?>> extractGenerics(Class<?> modelType, ResolvableType type) {
        if (!modelType.isAssignableFrom(type.resolve(Object.class))) {
            return Optional.empty();
        }
        ResolvableType unresolved = type.as(modelType).getGeneric(new int[]{0});
        Class resolved = unresolved.resolve();
        if (resolved == null) {
            return Optional.empty();
        }
        List<Class> nested = MODEL_TYPES.stream().filter(it -> it.isAssignableFrom(resolved)).toList();
        if (nested.isEmpty()) {
            return Optional.of(resolved);
        }
        return nested.stream().flatMap(it -> AotUtils.extractGenerics(it, unresolved).stream()).findFirst();
    }
}

