/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.support.DefaultExecutionGraphQlRequest;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class WebGraphQlRequest
extends DefaultExecutionGraphQlRequest
implements ExecutionGraphQlRequest {
    private static final MultiValueMap<String, HttpCookie> EMPTY_COOKIES = CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)new LinkedMultiValueMap());
    private final UriComponents uri;
    private final HttpHeaders headers;
    private final MultiValueMap<String, HttpCookie> cookies;
    @Nullable
    private final InetSocketAddress remoteAddress;
    private final Map<String, Object> attributes;

    public WebGraphQlRequest(URI uri, HttpHeaders headers, @Nullable MultiValueMap<String, HttpCookie> cookies, @Nullable InetSocketAddress remoteAddress, Map<String, Object> attributes, GraphQlRequest body, String id, @Nullable Locale locale) {
        this(uri, headers, cookies, remoteAddress, attributes, body.getDocument(), body.getOperationName(), body.getVariables(), body.getExtensions(), id, locale);
    }

    public WebGraphQlRequest(URI uri, HttpHeaders headers, @Nullable MultiValueMap<String, HttpCookie> cookies, @Nullable InetSocketAddress remoteAddress, Map<String, Object> attributes, Map<String, Object> body, String id, @Nullable Locale locale) {
        this(uri, headers, cookies, remoteAddress, attributes, WebGraphQlRequest.getQuery(body), WebGraphQlRequest.getOperation(body), WebGraphQlRequest.getMap("variables", body), WebGraphQlRequest.getMap("extensions", body), id, locale);
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public WebGraphQlRequest(URI uri, HttpHeaders headers, @Nullable MultiValueMap<String, HttpCookie> cookies, Map<String, Object> attributes, GraphQlRequest body, String id, @Nullable Locale locale) {
        this(uri, headers, cookies, null, attributes, body.getDocument(), body.getOperationName(), body.getVariables(), body.getExtensions(), id, locale);
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public WebGraphQlRequest(URI uri, HttpHeaders headers, @Nullable MultiValueMap<String, HttpCookie> cookies, Map<String, Object> attributes, Map<String, Object> body, String id, @Nullable Locale locale) {
        this(uri, headers, cookies, null, attributes, WebGraphQlRequest.getQuery(body), WebGraphQlRequest.getOperation(body), WebGraphQlRequest.getMap("variables", body), WebGraphQlRequest.getMap("extensions", body), id, locale);
    }

    private static String getQuery(Map<String, Object> body) {
        String query;
        Object value = body.get("query");
        if (!(value instanceof String) || !StringUtils.hasText((String)(query = (String)value))) {
            throw new ServerWebInputException("Invalid value for 'query'");
        }
        return (String)value;
    }

    @Nullable
    private static String getOperation(Map<String, Object> body) {
        Object value = body.get("operationName");
        if (value != null && !(value instanceof String)) {
            throw new ServerWebInputException("Invalid value for 'operationName'");
        }
        return (String)value;
    }

    @Nullable
    private static Map<String, Object> getMap(String key, Map<String, Object> body) {
        Object value = body.get(key);
        if (value != null && !(value instanceof Map)) {
            throw new ServerWebInputException("Invalid value for '" + key + "'");
        }
        return (Map)value;
    }

    private WebGraphQlRequest(URI uri, HttpHeaders headers, @Nullable MultiValueMap<String, HttpCookie> cookies, @Nullable InetSocketAddress remoteAddress, Map<String, Object> attributes, String document, @Nullable String operationName, @Nullable Map<String, Object> variables, @Nullable Map<String, Object> extensions, String id, @Nullable Locale locale) {
        super(document, operationName, variables, extensions, id, locale);
        Assert.notNull((Object)uri, (String)"URI is required'");
        Assert.notNull((Object)headers, (String)"HttpHeaders is required'");
        this.uri = UriComponentsBuilder.fromUri((URI)uri).build(true);
        this.headers = headers;
        this.cookies = cookies != null ? CollectionUtils.unmodifiableMultiValueMap(cookies) : EMPTY_COOKIES;
        this.remoteAddress = remoteAddress;
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    public UriComponents getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, HttpCookie> getCookies() {
        return this.cookies;
    }

    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

