/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.docs;

import com.tngtech.archunit.core.domain.JavaMethod;
import java.util.Optional;
import org.springframework.modulith.docs.Asciidoctor;
import org.springframework.modulith.docs.DocumentationSource;
import org.springframework.util.Assert;

class CodeReplacingDocumentationSource
implements DocumentationSource {
    private final DocumentationSource delegate;
    private final Asciidoctor codeSource;

    CodeReplacingDocumentationSource(DocumentationSource delegate, Asciidoctor asciidoctor) {
        Assert.notNull((Object)delegate, (String)"Delegate DocumentationSource must not be null!");
        Assert.notNull((Object)asciidoctor, (String)"Asciidoctor must not be null!");
        this.delegate = delegate;
        this.codeSource = asciidoctor;
    }

    @Override
    public Optional<String> getDocumentation(JavaMethod method) {
        return this.delegate.getDocumentation(method).map(this.codeSource::toAsciidoctor);
    }
}

