/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.util.CollectionUtils;

@NullUnmarked
public interface RedisListCommands {
    public Long rPush(byte @NonNull [] var1, byte[] ... var2);

    default public Long lPos(byte @NonNull [] key, byte @NonNull [] element) {
        return (Long)CollectionUtils.firstElement(this.lPos(key, element, null, null));
    }

    public List<Long> lPos(byte @NonNull [] var1, byte @NonNull [] var2, @Nullable Integer var3, @Nullable Integer var4);

    public Long lPush(byte @NonNull [] var1, byte[] ... var2);

    public Long rPushX(byte @NonNull [] var1, byte @NonNull [] var2);

    public Long lPushX(byte @NonNull [] var1, byte @NonNull [] var2);

    public Long lLen(byte @NonNull [] var1);

    public List<byte @NonNull []> lRange(byte @NonNull [] var1, long var2, long var4);

    public void lTrim(byte @NonNull [] var1, long var2, long var4);

    public byte[] lIndex(byte @NonNull [] var1, long var2);

    public Long lInsert(byte @NonNull [] var1, @NonNull Position var2, byte @NonNull [] var3, byte @NonNull [] var4);

    public byte[] lMove(byte @NonNull [] var1, byte @NonNull [] var2, @NonNull Direction var3, @NonNull Direction var4);

    public byte[] bLMove(byte @NonNull [] var1, byte @NonNull [] var2, @NonNull Direction var3, @NonNull Direction var4, double var5);

    public void lSet(byte @NonNull [] var1, long var2, byte @NonNull [] var4);

    public Long lRem(byte @NonNull [] var1, long var2, byte @NonNull [] var4);

    public byte[] lPop(byte @NonNull [] var1);

    public List<byte @NonNull []> lPop(byte @NonNull [] var1, long var2);

    public byte[] rPop(byte @NonNull [] var1);

    public List<byte @NonNull []> rPop(byte @NonNull [] var1, long var2);

    public @Nullable List<byte @NonNull []> bLPop(int var1, byte[] ... var2);

    public List<byte @NonNull []> bRPop(int var1, byte[] ... var2);

    public byte[] rPopLPush(byte @NonNull [] var1, byte @NonNull [] var2);

    public byte[] bRPopLPush(int var1, byte @NonNull [] var2, byte @NonNull [] var3);

    public static enum Direction {
        LEFT,
        RIGHT;


        public static Direction first() {
            return LEFT;
        }

        public static Direction last() {
            return RIGHT;
        }
    }

    public static enum Position {
        BEFORE,
        AFTER;

    }
}

