/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collection;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.redis.connection.DefaultedRedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterCommandsProvider;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;

@NullUnmarked
public interface RedisClusterConnection
extends RedisConnection,
DefaultedRedisClusterConnection,
RedisClusterCommandsProvider {
    public String ping(@NonNull RedisClusterNode var1);

    public Set<byte @NonNull []> keys(@NonNull RedisClusterNode var1, byte @NonNull [] var2);

    public Cursor<byte @NonNull []> scan(@NonNull RedisClusterNode var1, @NonNull ScanOptions var2);

    public byte[] randomKey(@NonNull RedisClusterNode var1);

    default public <T> T execute(@NonNull String command, byte @NonNull [] key, @NonNull Collection<byte @NonNull []> args) {
        Assert.notNull((Object)command, (String)"Command must not be null");
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(args, (String)"Args must not be null");
        byte[][] commandArgs = new byte[args.size() + 1][];
        commandArgs[0] = key;
        int targetIndex = 1;
        for (byte[] binaryArgument : args) {
            commandArgs[targetIndex++] = binaryArgument;
        }
        return (T)this.execute(command, commandArgs);
    }
}

