/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.data.redis.ClusterStateFailureException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClusterTopology {
    private final Set<RedisClusterNode> nodes;

    public ClusterTopology(@Nullable Set<RedisClusterNode> nodes) {
        this.nodes = nodes != null ? nodes : Collections.emptySet();
    }

    public Set<RedisClusterNode> getNodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public Set<RedisClusterNode> getActiveNodes() {
        LinkedHashSet<RedisClusterNode> activeNodes = new LinkedHashSet<RedisClusterNode>(this.nodes.size());
        for (RedisClusterNode node : this.nodes) {
            if (!node.isConnected() || node.isMarkedAsFail()) continue;
            activeNodes.add(node);
        }
        return activeNodes;
    }

    public Set<RedisClusterNode> getActiveMasterNodes() {
        LinkedHashSet<RedisClusterNode> activeMasterNodes = new LinkedHashSet<RedisClusterNode>(this.nodes.size());
        for (RedisClusterNode node : this.nodes) {
            if (!node.isMaster() || !node.isConnected() || node.isMarkedAsFail()) continue;
            activeMasterNodes.add(node);
        }
        return activeMasterNodes;
    }

    public Set<RedisClusterNode> getMasterNodes() {
        LinkedHashSet<RedisClusterNode> masterNodes = new LinkedHashSet<RedisClusterNode>(this.nodes.size());
        for (RedisClusterNode node : this.nodes) {
            if (!node.isMaster()) continue;
            masterNodes.add(node);
        }
        return masterNodes;
    }

    public Set<RedisClusterNode> getSlotServingNodes(int slot) {
        LinkedHashSet<RedisClusterNode> slotServingNodes = new LinkedHashSet<RedisClusterNode>(this.nodes.size());
        for (RedisClusterNode node : this.nodes) {
            if (!node.servesSlot(slot)) continue;
            slotServingNodes.add(node);
        }
        return slotServingNodes;
    }

    public RedisClusterNode getKeyServingMasterNode(byte[] key) {
        Assert.notNull((Object)key, (String)"Key for node lookup must not be null!");
        int slot = ClusterSlotHashUtil.calculateSlot(key);
        for (RedisClusterNode node : this.nodes) {
            if (!node.isMaster() || !node.servesSlot(slot)) continue;
            return node;
        }
        throw new ClusterStateFailureException(String.format("Could not find master node serving slot %s for key '%s',", slot, Arrays.toString(key)));
    }

    public RedisClusterNode lookup(String host, int port) {
        for (RedisClusterNode node : this.nodes) {
            if (!host.equals(node.getHost()) || node.getPort() == null || port != node.getPort()) continue;
            return node;
        }
        throw new ClusterStateFailureException(String.format("Could not find node at %s:%s. Is your cluster info up to date?", host, port));
    }

    public RedisClusterNode lookup(String nodeId) {
        Assert.notNull((Object)nodeId, (String)"NodeId must not be null!");
        for (RedisClusterNode node : this.nodes) {
            if (!nodeId.equals(node.getId())) continue;
            return node;
        }
        throw new ClusterStateFailureException(String.format("Could not find node at %s. Is your cluster info up to date?", nodeId));
    }

    public RedisClusterNode lookup(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"RedisClusterNode must not be null!");
        if (this.nodes.contains(node) && node.hasValidHost() && StringUtils.hasText((String)node.getId())) {
            return node;
        }
        if (node.hasValidHost() && node.getPort() != null) {
            return this.lookup(node.getHost(), node.getPort());
        }
        if (StringUtils.hasText((String)node.getId())) {
            return this.lookup(node.getId());
        }
        throw new ClusterStateFailureException(String.format("Could not find node at %s. Have you provided either host and port or the nodeId?", node));
    }

    public Set<RedisClusterNode> getKeyServingNodes(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null for Cluster Node lookup.");
        return this.getSlotServingNodes(ClusterSlotHashUtil.calculateSlot(key));
    }
}

