/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.aot.AotContext;
import org.springframework.data.aot.AotTypeConfiguration;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.aot.JpaRepositoryContributor;
import org.springframework.data.jpa.repository.config.InspectionClassLoader;
import org.springframework.data.jpa.repository.config.JpaMetamodelMappingContextFactoryBean;
import org.springframework.data.jpa.repository.support.DefaultJpaContext;
import org.springframework.data.jpa.repository.support.JpaEvaluationContextExtension;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryRegistrationAotProcessor;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JpaRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final Class<?> PAB_POST_PROCESSOR = PersistenceAnnotationBeanPostProcessor.class;
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final String ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE = "enableDefaultTransactions";
    private static final String JPA_METAMODEL_CACHE_CLEANUP_CLASSNAME = "org.springframework.data.jpa.util.JpaMetamodelCacheCleanup";
    private static final String ESCAPE_CHARACTER_PROPERTY = "escapeCharacter";
    private static final Logger log = LoggerFactory.getLogger(JpaRepositoryConfigExtension.class);
    private final Map<Object, String> entityManagerRefs = new LinkedHashMap<Object, String>();

    public String getModuleName() {
        return "JPA";
    }

    public String getRepositoryBaseClassName() {
        return SimpleJpaRepository.class.getName();
    }

    public String getRepositoryFactoryBeanClassName() {
        return JpaRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return this.getModuleName().toLowerCase(Locale.US);
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Arrays.asList(Entity.class, MappedSuperclass.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(JpaRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        Optional transactionManagerRef = source.getAttribute("transactionManagerRef");
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, (Object)transactionManagerRef.orElse(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME));
        if (this.entityManagerRefs.containsKey(source)) {
            builder.addPropertyValue("entityManager", (Object)new RuntimeBeanReference(this.entityManagerRefs.get(source), EntityManager.class));
        }
        builder.addPropertyValue(ESCAPE_CHARACTER_PROPERTY, (Object)JpaRepositoryConfigExtension.getEscapeCharacter(source).orElse(Character.valueOf('\\')));
        builder.addPropertyReference("mappingContext", "jpaMappingContext");
        if (source instanceof AnnotationRepositoryConfigurationSource) {
            builder.addPropertyValue("queryEnhancerSelector", source.getAttribute("queryEnhancerSelector", Class.class).orElse(null));
        }
    }

    public Class<? extends BeanRegistrationAotProcessor> getRepositoryAotProcessor() {
        return JpaRepositoryRegistrationAotProcessor.class;
    }

    private static Optional<Character> getEscapeCharacter(RepositoryConfigurationSource source) {
        try {
            return source.getAttribute(ESCAPE_CHARACTER_PROPERTY, Character.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, (Object)attributes.getBoolean(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Optional enableDefaultTransactions = config.getAttribute(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE);
        if (enableDefaultTransactions.isPresent() && StringUtils.hasText((String)((String)enableDefaultTransactions.get()))) {
            builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, enableDefaultTransactions.get());
        }
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        this.registerSharedEntityMangerIfNotAlreadyRegistered(registry, config);
        Object source = config.getSource();
        JpaRepositoryConfigExtension.registerLazyIfNotAlreadyRegistered(() -> new RootBeanDefinition(JpaMetamodelMappingContextFactoryBean.class), (BeanDefinitionRegistry)registry, (String)"jpaMappingContext", (Object)source);
        JpaRepositoryConfigExtension.registerLazyIfNotAlreadyRegistered(() -> new RootBeanDefinition(PAB_POST_PROCESSOR), (BeanDefinitionRegistry)registry, (String)"org.springframework.context.annotation.internalPersistenceAnnotationProcessor", (Object)source);
        JpaRepositoryConfigExtension.registerLazyIfNotAlreadyRegistered(() -> {
            RootBeanDefinition contextDefinition = new RootBeanDefinition(DefaultJpaContext.class);
            contextDefinition.setAutowireMode(3);
            return contextDefinition;
        }, (BeanDefinitionRegistry)registry, (String)"jpaContext", (Object)source);
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered(() -> new RootBeanDefinition(JPA_METAMODEL_CACHE_CLEANUP_CLASSNAME), (BeanDefinitionRegistry)registry, (String)JPA_METAMODEL_CACHE_CLEANUP_CLASSNAME, (Object)source);
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered(() -> {
            Object value = config instanceof AnnotationRepositoryConfigurationSource ? config.getRequiredAttribute(ESCAPE_CHARACTER_PROPERTY, Character.class) : config.getAttribute(ESCAPE_CHARACTER_PROPERTY).orElse("\\");
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(JpaEvaluationContextExtension.class);
            builder.addConstructorArgValue(value);
            return builder.getBeanDefinition();
        }, (BeanDefinitionRegistry)registry, (String)JpaEvaluationContextExtension.class.getName(), (Object)source);
    }

    private void registerSharedEntityMangerIfNotAlreadyRegistered(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        String entityManagerBeanRef = JpaRepositoryConfigExtension.getEntityManagerBeanRef(config);
        String sharedEntityManagerBeanRef = this.lookupSharedEntityManagerBeanRef(entityManagerBeanRef, registry);
        if (sharedEntityManagerBeanRef != null) {
            this.entityManagerRefs.put(config, sharedEntityManagerBeanRef);
            return;
        }
        String entityManagerBeanName = "jpaSharedEM_" + entityManagerBeanRef;
        if (!registry.containsBeanDefinition(entityManagerBeanName)) {
            AbstractBeanDefinition entityManager = JpaRepositoryConfigExtension.getEntityManagerBeanDefinitionFor(config, null);
            entityManager.setRole(1);
            entityManager.setPrimary(false);
            entityManager.setAutowireCandidate(false);
            registry.registerBeanDefinition(entityManagerBeanName, (BeanDefinition)entityManager);
        }
        this.entityManagerRefs.put(config, entityManagerBeanName);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String lookupSharedEntityManagerBeanRef(String entityManagerBeanRef, BeanDefinitionRegistry registry) {
        void cbf;
        ConfigurableApplicationContext cac;
        ConfigurableListableBeanFactory configurableListableBeanFactory;
        if (!registry.containsBeanDefinition(entityManagerBeanRef)) {
            return null;
        }
        BeanDefinitionRegistry introspect = registry;
        if (introspect instanceof ConfigurableApplicationContext && (configurableListableBeanFactory = (cac = (ConfigurableApplicationContext)introspect).getBeanFactory()) instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry br;
            introspect = br = (BeanDefinitionRegistry)configurableListableBeanFactory;
        }
        if (!(introspect instanceof ConfigurableBeanFactory)) {
            return null;
        }
        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)introspect;
        BeanDefinition beanDefinition = cbf.getMergedBeanDefinition(entityManagerBeanRef);
        if (ObjectUtils.isEmpty((Object)beanDefinition.getBeanClassName())) {
            return null;
        }
        Class beanClass = org.springframework.data.util.ClassUtils.loadIfPresent((String)beanDefinition.getBeanClassName(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        return beanClass != null && AbstractEntityManagerFactoryBean.class.isAssignableFrom(beanClass) ? entityManagerBeanRef : null;
    }

    @Nullable
    protected ClassLoader getConfigurationInspectionClassLoader(ResourceLoader loader) {
        ClassLoader classLoader = loader.getClassLoader();
        return classLoader != null && LazyJvmAgent.isActive(loader.getClassLoader()) ? new InspectionClassLoader(classLoader) : classLoader;
    }

    private static AbstractBeanDefinition getEntityManagerBeanDefinitionFor(RepositoryConfigurationSource config, @Nullable Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.orm.jpa.SharedEntityManagerCreator");
        builder.setFactoryMethod("createSharedEntityManager");
        builder.addConstructorArgReference(JpaRepositoryConfigExtension.getEntityManagerBeanRef(config));
        AbstractBeanDefinition bean = builder.getRawBeanDefinition();
        bean.setSource(source);
        return bean;
    }

    private static String getEntityManagerBeanRef(RepositoryConfigurationSource config) {
        Optional entityManagerFactoryRef = config.getAttribute("entityManagerFactoryRef");
        return entityManagerFactoryRef.orElse("entityManagerFactory");
    }

    public static class JpaRepositoryRegistrationAotProcessor
    extends RepositoryRegistrationAotProcessor {
        public static final String USE_ENTITY_MANAGER = "spring.aot.jpa.repositories.use-entitymanager";
        private static final String MODULE_NAME = "jpa";

        protected void configureTypeContributions(AotRepositoryContext repositoryContext, GenerationContext generationContext) {
            super.configureTypeContributions(repositoryContext, generationContext);
        }

        protected void configureTypeContribution(Class<?> type, AotContext aotContext) {
            aotContext.typeConfiguration(type, config -> {
                AotTypeConfiguration aotTypeConfiguration = config.contributeAccessors().forQuerydsl();
            });
        }

        @Nullable
        protected JpaRepositoryContributor contributeAotRepository(AotRepositoryContext repositoryContext) {
            if (!repositoryContext.isGeneratedRepositoriesEnabled(MODULE_NAME)) {
                return null;
            }
            ConfigurableListableBeanFactory beanFactory = repositoryContext.getBeanFactory();
            Environment environment = repositoryContext.getEnvironment();
            boolean useEntityManager = (Boolean)environment.getProperty(USE_ENTITY_MANAGER, Boolean.class, (Object)false);
            if (useEntityManager) {
                Optional entityManagerFactoryRef = repositoryContext.getConfigurationSource().getAttribute("entityManagerFactoryRef");
                log.debug("Using EntityManager '%s' for AOT repository generation".formatted(entityManagerFactoryRef.orElse("")));
                EntityManagerFactory emf = entityManagerFactoryRef.map(it -> (EntityManagerFactory)beanFactory.getBean(it, EntityManagerFactory.class)).orElseGet(() -> (EntityManagerFactory)beanFactory.getBean(EntityManagerFactory.class));
                return new JpaRepositoryContributor(repositoryContext, emf);
            }
            ObjectProvider managedTypesProvider = beanFactory.getBeanProvider(PersistenceManagedTypes.class);
            PersistenceManagedTypes managedTypes = (PersistenceManagedTypes)managedTypesProvider.getIfUnique();
            if (managedTypes != null) {
                log.debug("Using PersistenceManagedTypes for AOT repository generation");
                return new JpaRepositoryContributor(repositoryContext, managedTypes);
            }
            ObjectProvider infoProvider = beanFactory.getBeanProvider(PersistenceUnitInfo.class);
            PersistenceUnitInfo unitInfo = (PersistenceUnitInfo)infoProvider.getIfUnique();
            if (unitInfo != null) {
                log.debug("Using PersistenceUnitInfo for AOT repository generation");
                return new JpaRepositoryContributor(repositoryContext, unitInfo);
            }
            log.debug("Using scanned types for AOT repository generation");
            return new JpaRepositoryContributor(repositoryContext);
        }
    }

    static class LazyJvmAgent {
        private static final Set<String> AGENT_CLASSES;

        static {
            LinkedHashSet<String> agentClasses = new LinkedHashSet<String>();
            agentClasses.add("org.springframework.instrument.InstrumentationSavingAgent");
            agentClasses.add("org.eclipse.persistence.internal.jpa.deployment.JavaSECMPInitializerAgent");
            AGENT_CLASSES = Collections.unmodifiableSet(agentClasses);
        }

        private LazyJvmAgent() {
        }

        static boolean isActive(@Nullable ClassLoader classLoader) {
            return AGENT_CLASSES.stream().anyMatch(agentClass -> ClassUtils.isPresent((String)agentClass, (ClassLoader)classLoader));
        }
    }
}

