/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.util.StringUtils;

class ExpressionFactorySupport {
    static final Map<// Could not load outer class - annotation placement on inner may be incorrect
    Attribute.PersistentAttributeType, @Nullable Class<? extends Annotation>> ASSOCIATION_TYPES;

    static {
        HashMap<// Could not load outer class - annotation placement on inner may be incorrect
        Attribute.PersistentAttributeType, @Nullable Class> persistentAttributeTypes = new HashMap<Attribute.PersistentAttributeType, Class>();
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ONE_TO_ONE, OneToOne.class);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ONE_TO_MANY, null);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.MANY_TO_ONE, ManyToOne.class);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.MANY_TO_MANY, null);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ELEMENT_COLLECTION, null);
        ASSOCIATION_TYPES = Collections.unmodifiableMap(persistentAttributeTypes);
    }

    ExpressionFactorySupport() {
    }

    /*
     * WARNING - void declaration
     */
    public boolean requiresOuterJoin(ModelPathResolver resolver, PropertyPath property, boolean isForSelection, boolean hasRequiredOuterJoin, boolean isLeafProperty, boolean isRelationshipId) {
        boolean isInverseOptionalOneToOne;
        void attribute;
        Bindable<?> propertyPathModel = resolver.resolve(property);
        if (!(propertyPathModel instanceof Attribute)) {
            return false;
        }
        Attribute attribute2 = (Attribute)propertyPathModel;
        if (!ASSOCIATION_TYPES.containsKey(attribute.getPersistentAttributeType())) {
            return false;
        }
        boolean isCollection = attribute.isCollection();
        boolean bl = isInverseOptionalOneToOne = Attribute.PersistentAttributeType.ONE_TO_ONE == attribute.getPersistentAttributeType() && StringUtils.hasText((String)ExpressionFactorySupport.getAnnotationProperty(attribute, "mappedBy", ""));
        if (!(!isLeafProperty && !isRelationshipId || isForSelection || isCollection || isInverseOptionalOneToOne || hasRequiredOuterJoin)) {
            return false;
        }
        return hasRequiredOuterJoin || ExpressionFactorySupport.getAnnotationProperty(attribute, "optional", true) != false;
    }

    public boolean isRelationshipId(ModelPathResolver resolver, PropertyPath property) {
        SingularAttribute sa;
        if (!property.hasNext()) {
            return false;
        }
        Bindable<?> bindable = resolver.resolveNext(property);
        return bindable instanceof SingularAttribute && (sa = (SingularAttribute)bindable).isId();
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T getAnnotationProperty(Attribute<?, ?> attribute, String propertyName, T defaultValue) {
        void annotatedMember;
        Class<? extends Annotation> associationAnnotation = ASSOCIATION_TYPES.get(attribute.getPersistentAttributeType());
        if (associationAnnotation == null) {
            return defaultValue;
        }
        Member member = attribute.getJavaMember();
        if (!(member instanceof AnnotatedElement)) {
            return defaultValue;
        }
        AnnotatedElement annotatedElement = (AnnotatedElement)((Object)member);
        Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)annotatedMember, associationAnnotation);
        if (annotation == null) {
            return defaultValue;
        }
        Object value = AnnotationUtils.getValue((Annotation)annotation, (String)propertyName);
        return (T)(value != null ? value : defaultValue);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    static ManagedType<?> getManagedTypeForModel(@Nullable Object model) {
        ManagedType managedType;
        void singularAttribute;
        if (model instanceof ManagedType) {
            ManagedType managedType2 = (ManagedType)model;
            return managedType2;
        }
        if (model instanceof PluralAttribute) {
            ManagedType managedType3;
            PluralAttribute pa = (PluralAttribute)model;
            Type type = pa.getElementType();
            return type instanceof ManagedType ? (managedType3 = (ManagedType)type) : null;
        }
        if (!(model instanceof SingularAttribute)) {
            return null;
        }
        SingularAttribute managedType3 = (SingularAttribute)model;
        Type type = singularAttribute.getType();
        return type instanceof ManagedType ? (managedType = (ManagedType)type) : null;
    }

    public static interface ModelPathResolver {
        @Nullable
        public Bindable<?> resolve(PropertyPath var1);

        @Nullable
        public Bindable<?> resolveNext(PropertyPath var1);
    }
}

