/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.support;

import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClasspathScanningPersistenceUnitPostProcessor
implements PersistenceUnitPostProcessor,
ResourceLoaderAware,
EnvironmentAware {
    private static final Log LOG = LogFactory.getLog(ClasspathScanningPersistenceUnitPostProcessor.class);
    private final String basePackage;
    private ResourcePatternResolver mappingFileResolver = new PathMatchingResourcePatternResolver();
    private Environment environment = new StandardEnvironment();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    @Nullable
    private String mappingFileNamePattern;

    public ClasspathScanningPersistenceUnitPostProcessor(String basePackage) {
        Assert.hasText((String)basePackage, (String)"Base package must not be null or empty");
        this.basePackage = basePackage;
    }

    public void setMappingFileNamePattern(String mappingFilePattern) {
        Assert.hasText((String)mappingFilePattern, (String)"Mapping file pattern must not be null or empty");
        this.mappingFileNamePattern = mappingFilePattern;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null");
        this.mappingFileResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        this.environment = environment;
    }

    public void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.setEnvironment(this.environment);
        provider.setResourceLoader(this.resourceLoader);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(MappedSuperclass.class));
        for (BeanDefinition definition : provider.findCandidateComponents(this.basePackage)) {
            LOG.debug((Object)String.format("Registering classpath-scanned entity %s in persistence unit info", definition.getBeanClassName()));
            if (definition.getBeanClassName() == null) continue;
            pui.addManagedClassName(definition.getBeanClassName());
        }
        for (String location : this.scanForMappingFileLocations()) {
            LOG.debug((Object)String.format("Registering classpath-scanned entity mapping file %s in persistence unit info", location));
            pui.addMappingFileName(location);
        }
    }

    private Set<String> scanForMappingFileLocations() {
        Resource[] scannedResources;
        if (!StringUtils.hasText((String)this.mappingFileNamePattern)) {
            return Collections.emptySet();
        }
        char slash = '/';
        String basePackagePathComponent = this.basePackage.replace('.', slash);
        String path = "classpath*:" + basePackagePathComponent + slash + this.mappingFileNamePattern;
        try {
            scannedResources = this.mappingFileResolver.getResources(path);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Cannot load mapping files from path %s", path), e);
        }
        HashSet<String> mappingFileUris = new HashSet<String>();
        Resource[] resourceArray = scannedResources;
        int n = scannedResources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            try {
                String resourcePath = ClasspathScanningPersistenceUnitPostProcessor.getResourcePath(resource.getURI());
                String resourcePathInClasspath = resourcePath.substring(resourcePath.indexOf(basePackagePathComponent));
                mappingFileUris.add(resourcePathInClasspath);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Couldn't get URI for %s", resource), e);
            }
            ++n2;
        }
        return mappingFileUris;
    }

    private static String getResourcePath(URI uri) {
        int exclamationMarkIndex;
        String rawPath;
        if (uri.isOpaque() && (rawPath = uri.toString()) != null && (exclamationMarkIndex = rawPath.lastIndexOf(33)) > -1) {
            return rawPath.substring(exclamationMarkIndex + 1);
        }
        return uri.getPath();
    }
}

