/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.springframework.data.jpa.repository.query.EmptyQueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

interface QueryTokenStream
extends Streamable<QueryToken> {
    public static QueryTokenStream empty() {
        return EmptyQueryTokenStream.INSTANCE;
    }

    public static QueryTokenStream from(QueryToken token) {
        return QueryRenderer.from(Collections.singletonList(token));
    }

    public static QueryTokenStream ofToken(TerminalNode node) {
        return QueryTokenStream.from(QueryTokens.token(node));
    }

    public static QueryTokenStream ofToken(Token node) {
        return QueryTokenStream.from(QueryTokens.token(node));
    }

    public static <T> QueryTokenStream concat(Collection<T> elements, Function<T, QueryTokenStream> visitor, QueryToken separator) {
        return QueryTokenStream.concat(elements, visitor, QueryRenderer::inline, separator);
    }

    public static <T> QueryTokenStream concatExpressions(Collection<T> elements, Function<T, QueryTokenStream> visitor, QueryToken separator) {
        return QueryTokenStream.concat(elements, visitor, QueryRenderer::ofExpression, separator);
    }

    public static <T> QueryTokenStream concat(Collection<T> elements, Function<T, QueryTokenStream> visitor, Function<QueryTokenStream, QueryTokenStream> postProcess, QueryToken separator) {
        QueryRenderer.QueryRendererBuilder builder = null;
        QueryTokenStream firstElement = null;
        for (T element : elements) {
            QueryTokenStream tokenStream = postProcess.apply(visitor.apply(element));
            if (firstElement == null) {
                firstElement = tokenStream;
                continue;
            }
            if (builder == null) {
                builder = QueryRenderer.builder();
                builder.append(firstElement);
            }
            if (!builder.isEmpty()) {
                builder.append(separator);
            }
            builder.append(tokenStream);
        }
        if (builder != null) {
            return builder;
        }
        if (firstElement != null) {
            return firstElement;
        }
        return QueryTokenStream.empty();
    }

    @Nullable
    default public QueryToken getFirst() {
        Iterator it = this.iterator();
        return it.hasNext() ? (QueryToken)it.next() : null;
    }

    default public QueryToken getRequiredFirst() {
        QueryToken first = this.getFirst();
        if (first == null) {
            throw new NoSuchElementException("No token in the stream");
        }
        return first;
    }

    @Nullable
    default public QueryToken getLast() {
        return (QueryToken)CollectionUtils.lastElement((List)this.toList());
    }

    default public QueryToken getRequiredLast() {
        QueryToken last = this.getLast();
        if (last == null) {
            throw new NoSuchElementException("No token in the stream");
        }
        return last;
    }

    public boolean isExpression();

    public int size();

    public boolean isEmpty();
}

