/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.criteria.ParameterExpression;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

interface QueryParameterSetter {
    public static final QueryParameterSetter NOOP = (query, values, errorHandler) -> {};

    public static QueryParameterSetter create(Function<JpaParametersParameterAccessor, Object> valueExtractor, Parameter<?> parameter, @Nullable TemporalType temporalType) {
        return temporalType == null ? new NamedOrIndexedQueryParameterSetter(valueExtractor, parameter) : new TemporalParameterSetter(valueExtractor, parameter, temporalType);
    }

    public void setParameter(BindableQuery var1, JpaParametersParameterAccessor var2, ErrorHandler var3);

    public static class BindableQuery
    extends QueryMetadata {
        private final Query query;
        private final Query unwrapped;

        BindableQuery(Query query) {
            super(query);
            this.query = query;
            this.unwrapped = Proxy.isProxyClass(query.getClass()) ? (Query)query.unwrap(null) : query;
        }

        public static BindableQuery from(Query query) {
            return new BindableQuery(query);
        }

        public Query getQuery() {
            return this.query;
        }

        public <T> Query setParameter(Parameter<T> param, T value) {
            return this.unwrapped.setParameter(param, value);
        }

        public Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
            return this.unwrapped.setParameter(param, value, temporalType);
        }

        public Query setParameter(String name, Object value) {
            return this.unwrapped.setParameter(name, value);
        }

        public Query setParameter(String name, Date value, TemporalType temporalType) {
            return this.query.setParameter(name, value, temporalType);
        }

        public Query setParameter(int position, Object value) {
            return this.unwrapped.setParameter(position, value);
        }

        public Query setParameter(int position, Date value, TemporalType temporalType) {
            return this.unwrapped.setParameter(position, value, temporalType);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ErrorHandling implements ErrorHandler
    {
        STRICT{

            public void handleError(Throwable t) {
                if (t instanceof RuntimeException) {
                    RuntimeException rx = (RuntimeException)t;
                    throw rx;
                }
                throw new RuntimeException(t);
            }
        }
        ,
        LENIENT{

            public void handleError(Throwable t) {
                LOG.info((Object)"Silently ignoring", t);
            }
        };

        private static final Log LOG;

        static {
            LOG = LogFactory.getLog(ErrorHandling.class);
        }
    }

    public static class NamedOrIndexedQueryParameterSetter
    implements QueryParameterSetter {
        private final Function<JpaParametersParameterAccessor, Object> valueExtractor;
        private final Parameter<?> parameter;

        private NamedOrIndexedQueryParameterSetter(Function<JpaParametersParameterAccessor, Object> valueExtractor, Parameter<?> parameter) {
            Assert.notNull(valueExtractor, (String)"ValueExtractor must not be null");
            this.valueExtractor = valueExtractor;
            this.parameter = parameter;
        }

        @Override
        public void setParameter(BindableQuery query, JpaParametersParameterAccessor accessor, ErrorHandler errorHandler) {
            Object value = this.valueExtractor.apply(accessor);
            try {
                this.setParameter(query, value, errorHandler);
            }
            catch (RuntimeException e) {
                errorHandler.handleError((Throwable)e);
            }
        }

        private void setParameter(BindableQuery query, Object value, ErrorHandler errorHandler) {
            if (this.parameter instanceof ParameterExpression) {
                query.setParameter(this.parameter, value);
            } else if (query.hasNamedParameters() && this.parameter.getName() != null) {
                query.setParameter(this.parameter.getName(), value);
            } else {
                Integer position = this.parameter.getPosition();
                if (position != null && (query.getParameters().size() >= position || errorHandler == ErrorHandling.LENIENT || query.registerExcessParameters())) {
                    query.setParameter(position, value);
                }
            }
        }
    }

    public static class QueryMetadata {
        private final boolean namedParameters;
        private final Set<Parameter<?>> parameters;
        private final boolean registerExcessParameters;

        QueryMetadata(Query query) {
            this.namedParameters = QueryUtils.hasNamedParameter(query);
            this.parameters = query.getParameters();
            this.registerExcessParameters = query.getParameters().size() == 0 && QueryMetadata.unwrapClass(query).getName().startsWith("org.eclipse");
        }

        public Set<Parameter<?>> getParameters() {
            return this.parameters;
        }

        public boolean hasNamedParameters() {
            return this.namedParameters;
        }

        public boolean registerExcessParameters() {
            return this.registerExcessParameters;
        }

        private static Class<?> unwrapClass(Query query) {
            Class<?> queryType = query.getClass();
            try {
                return Proxy.isProxyClass(queryType) ? query.unwrap(null).getClass() : queryType;
            }
            catch (RuntimeException e) {
                LogFactory.getLog(QueryMetadata.class).warn((Object)"Failed to unwrap actual class for Query proxy", (Throwable)e);
                return queryType;
            }
        }
    }

    public static class TemporalParameterSetter
    implements QueryParameterSetter {
        private final Function<JpaParametersParameterAccessor, Object> valueExtractor;
        private final Parameter<?> parameter;
        private final TemporalType temporalType;

        private TemporalParameterSetter(Function<JpaParametersParameterAccessor, Object> valueExtractor, Parameter<?> parameter, TemporalType temporalType) {
            this.valueExtractor = valueExtractor;
            this.parameter = parameter;
            this.temporalType = temporalType;
        }

        @Override
        public void setParameter(BindableQuery query, JpaParametersParameterAccessor accessor, ErrorHandler errorHandler) {
            Date value = (Date)accessor.potentiallyUnwrap(this.valueExtractor.apply(accessor));
            try {
                this.setParameter(query, value, errorHandler);
            }
            catch (RuntimeException e) {
                errorHandler.handleError((Throwable)e);
            }
        }

        private void setParameter(BindableQuery query, Date date, ErrorHandler errorHandler) {
            if (this.parameter instanceof ParameterExpression) {
                query.setParameter(this.parameter, date, this.temporalType);
            } else if (query.hasNamedParameters() && this.parameter.getName() != null) {
                query.setParameter(this.parameter.getName(), date, this.temporalType);
            } else {
                Integer position = this.parameter.getPosition();
                if (position != null && (query.getParameters().size() >= this.parameter.getPosition() || query.registerExcessParameters() || errorHandler == ErrorHandling.LENIENT)) {
                    query.setParameter(this.parameter.getPosition(), date, this.temporalType);
                }
            }
        }
    }
}

