/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.BadJpqlGrammarErrorListener;
import org.springframework.data.jpa.repository.query.BadJpqlGrammarException;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.EqlCountQueryTransformer;
import org.springframework.data.jpa.repository.query.EqlLexer;
import org.springframework.data.jpa.repository.query.EqlParser;
import org.springframework.data.jpa.repository.query.EqlQueryIntrospector;
import org.springframework.data.jpa.repository.query.EqlSortedQueryTransformer;
import org.springframework.data.jpa.repository.query.HibernateQueryInformation;
import org.springframework.data.jpa.repository.query.HqlCountQueryTransformer;
import org.springframework.data.jpa.repository.query.HqlLexer;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.HqlQueryIntrospector;
import org.springframework.data.jpa.repository.query.HqlSortedQueryTransformer;
import org.springframework.data.jpa.repository.query.JpqlCountQueryTransformer;
import org.springframework.data.jpa.repository.query.JpqlLexer;
import org.springframework.data.jpa.repository.query.JpqlParser;
import org.springframework.data.jpa.repository.query.JpqlQueryIntrospector;
import org.springframework.data.jpa.repository.query.JpqlSortedQueryTransformer;
import org.springframework.data.jpa.repository.query.ParsedQueryIntrospector;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryInformation;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class JpaQueryEnhancer<Q extends QueryInformation>
implements QueryEnhancer {
    private final ParserRuleContext context;
    private final Q queryInformation;
    private final String projection;
    private final SortedQueryRewriteFunction<Q> sortFunction;
    private final BiFunction<String, Q, ParseTreeVisitor<QueryTokenStream>> countQueryFunction;

    JpaQueryEnhancer(ParserRuleContext context, ParsedQueryIntrospector<Q> introspector, SortedQueryRewriteFunction<Q> sortFunction, BiFunction<String, Q, ParseTreeVisitor<QueryTokenStream>> countQueryFunction) {
        this.context = context;
        this.sortFunction = sortFunction;
        this.countQueryFunction = countQueryFunction;
        introspector.visit((ParseTree)context);
        this.queryInformation = introspector.getParsedQueryInformation();
        List<QueryToken> tokens = ((QueryInformation)this.queryInformation).getProjection();
        this.projection = tokens.isEmpty() ? "" : new QueryRenderer.TokenRenderer(tokens).render();
    }

    static <P extends Parser> ParserRuleContext parse(String query, Function<CharStream, Lexer> lexerFactoryFunction, Function<TokenStream, P> parserFactoryFunction, Function<P, ParserRuleContext> parseFunction) {
        Lexer lexer = lexerFactoryFunction.apply((CharStream)CharStreams.fromString((String)query));
        Parser parser = (Parser)parserFactoryFunction.apply((TokenStream)new CommonTokenStream((TokenSource)lexer));
        String grammar = lexer.getGrammarFileName();
        int dot = grammar.lastIndexOf(46);
        if (dot != -1) {
            grammar = grammar.substring(0, dot);
        }
        JpaQueryEnhancer.configureParser(query, grammar.toUpperCase(), lexer, parser);
        return parseFunction.apply(parser);
    }

    static void configureParser(String query, String grammar, Lexer lexer, Parser parser) {
        BadJpqlGrammarErrorListener errorListener = new BadJpqlGrammarErrorListener(query, grammar);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
    }

    public static JpaQueryEnhancer<QueryInformation> forJpql(DeclaredQuery query) {
        Assert.notNull((Object)query, (String)"DeclaredQuery must not be null!");
        return JpqlQueryParser.parseQuery(query.getQueryString());
    }

    public static JpaQueryEnhancer<HibernateQueryInformation> forHql(DeclaredQuery query) {
        Assert.notNull((Object)query, (String)"DeclaredQuery must not be null!");
        return HqlQueryParser.parseQuery(query.getQueryString());
    }

    public static JpaQueryEnhancer<QueryInformation> forEql(DeclaredQuery query) {
        Assert.notNull((Object)query, (String)"DeclaredQuery must not be null!");
        return EqlQueryParser.parseQuery(query.getQueryString());
    }

    ParserRuleContext getContext() {
        return this.context;
    }

    Q getQueryInformation() {
        return this.queryInformation;
    }

    @Override
    public boolean hasConstructorExpression() {
        return ((QueryInformation)this.queryInformation).hasConstructorExpression();
    }

    @Override
    public String detectAlias() {
        return ((QueryInformation)this.queryInformation).getAlias();
    }

    @Override
    public String getProjection() {
        return this.projection;
    }

    @Override
    public Set<String> getJoinAliases() {
        return Set.of();
    }

    @Override
    public DeclaredQuery getQuery() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String applySorting(Sort sort) {
        return QueryRenderer.TokenRenderer.render((Iterable)this.sortFunction.apply(sort, this.queryInformation, null).visit((ParseTree)this.context));
    }

    @Override
    public String rewrite(QueryEnhancer.QueryRewriteInformation rewriteInformation) {
        return QueryRenderer.TokenRenderer.render((Iterable)this.sortFunction.apply(rewriteInformation.getSort(), this.queryInformation, rewriteInformation.getReturnedType()).visit((ParseTree)this.context));
    }

    @Override
    public String applySorting(Sort sort, String alias) {
        return this.applySorting(sort);
    }

    @Override
    public String createCountQueryFor() {
        return this.createCountQueryFor(null);
    }

    @Override
    public String createCountQueryFor(@Nullable String countProjection) {
        return QueryRenderer.TokenRenderer.render((Iterable)this.countQueryFunction.apply(countProjection, this.queryInformation).visit((ParseTree)this.context));
    }

    static class EqlQueryParser
    extends JpaQueryEnhancer<QueryInformation> {
        private EqlQueryParser(String query) {
            super(EqlQueryParser.parse(query, EqlLexer::new, EqlParser::new, EqlParser::start), new EqlQueryIntrospector(), EqlSortedQueryTransformer::new, EqlCountQueryTransformer::new);
        }

        public static EqlQueryParser parseQuery(String query) throws BadJpqlGrammarException {
            return new EqlQueryParser(query);
        }
    }

    static class HqlQueryParser
    extends JpaQueryEnhancer<HibernateQueryInformation> {
        private HqlQueryParser(String query) {
            super(HqlQueryParser.parse(query, HqlLexer::new, HqlParser::new, HqlParser::start), new HqlQueryIntrospector(), HqlSortedQueryTransformer::new, HqlCountQueryTransformer::new);
        }

        public static HqlQueryParser parseQuery(String query) throws BadJpqlGrammarException {
            return new HqlQueryParser(query);
        }
    }

    static class JpqlQueryParser
    extends JpaQueryEnhancer<QueryInformation> {
        private JpqlQueryParser(String query) {
            super(JpqlQueryParser.parse(query, JpqlLexer::new, JpqlParser::new, JpqlParser::start), new JpqlQueryIntrospector(), JpqlSortedQueryTransformer::new, JpqlCountQueryTransformer::new);
        }

        public static JpqlQueryParser parseQuery(String query) throws BadJpqlGrammarException {
            return new JpqlQueryParser(query);
        }
    }

    @FunctionalInterface
    static interface SortedQueryRewriteFunction<Q> {
        public ParseTreeVisitor<QueryTokenStream> apply(Sort var1, Q var2, @Nullable ReturnedType var3);
    }
}

